/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;

public abstract class AbstractAnalysisPortCheck
extends OVMComplianceCheck {
    private String libAnalysisPortName;

    protected AbstractAnalysisPortCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.libAnalysisPortName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_port");
    }

    protected void checkAnalysisPort(Collection<RfClass> components, String componentText) {
        if (components == null) {
            return;
        }
        for (RfClass component : components) {
            this.notifyCheckAlive();
            if (component == null) continue;
            boolean found = false;
            RfClass currentClass = component;
            while (currentClass != null && !found) {
                List<RfField> fields = this.checkIfAnalysisPortExist(currentClass, componentText, true);
                if (fields != null && !fields.isEmpty()) {
                    found = true;
                }
                currentClass = currentClass.getParent();
            }
            if (found) continue;
            this.addHit(component, String.valueOf(DVTStringUtil.capitalizeFirstLetter((String)this.libAnalysisPortName)) + " was not found in " + componentText + " '" + component.getName() + "'!");
        }
    }

    protected List<RfField> checkIfAnalysisPortExist(RfClass component, String componentText, boolean checkIfInMacro) {
        ArrayList<RfField> fieldsWithAnalysisPorts = new ArrayList<RfField>();
        if (this.fOVMProject.isOVMElement(component)) {
            return fieldsWithAnalysisPorts;
        }
        List<RfField> fields = component.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null) {
            return fieldsWithAnalysisPorts;
        }
        for (RfField field : fields) {
            RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (fieldType == null || !fieldType.isSubClass(this.libAnalysisPortName, true)) continue;
            if (checkIfInMacro && LintUtils.getMacroCallLevel(field) > 0) {
                this.addHit(field, String.valueOf(DVTStringUtil.capitalizeFirstLetter((String)this.libAnalysisPortName)) + " is declared in a macro in " + componentText + " '" + component.getName() + "'!");
            }
            fieldsWithAnalysisPorts.add(field);
        }
        return fieldsWithAnalysisPorts;
    }

    public String getLibAnalysisPortName() {
        return this.libAnalysisPortName;
    }
}

