/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Collection;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

public abstract class AbstractBaseClassCheck
extends AbstractNamePatternParametersCheck {
    @CheckParameter(defaultValue="false", description="Only direct inheritance is allowed.", name="directInheritanceOnly", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pDirectInheritanceOnlyValue;
    @CheckParameter(defaultValue="", description="Check if all components inherit from 'baseClass'.", name="baseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pBaseClassValue;

    public AbstractBaseClassCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected abstract String getComponentName();

    protected abstract RfClass getBaseClass();

    protected abstract Collection<RfClass> getComponents();

    @Override
    public void performCheckImpl() {
        Collection<RfClass> components = this.getComponents();
        if (components == null || components.isEmpty()) {
            return;
        }
        RfClass baseClass = this.getBaseClass();
        if (baseClass == null) {
            if (!this.pBaseClassValue.isEmpty()) {
                this.signalParamError("Class '" + this.pBaseClassValue + "' not found!", false);
            }
            return;
        }
        for (RfClass component : components) {
            if (this.checkPreWaivers(component.getFile()) || component.equals(baseClass)) continue;
            this.notifyCheckAlive();
            if (component.getParent() != null && !(this.pDirectInheritanceOnlyValue ? !component.getParent().getFullName().equals(baseClass.getFullName()) : !LintUtils.isSubClassOf(component, baseClass))) continue;
            this.addHit(component, String.valueOf(this.capitalize(this.getComponentName())) + " '" + component.getFullName() + "' must extend '" + baseClass.getFullName() + "' class!");
        }
    }

    private String capitalize(String s) {
        return s.length() > 0 ? String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1) : s;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

