/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

public abstract class AbstractConstructorCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, additional statements are allowed in the constructor.", name="allowAdditionalStatements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowAdditionalStatements;
    @CheckParameter(defaultValue="false", description="When true, coverage instantiations are allowed in the constructor.", name="allowCoverageInstantiation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowCoverageInstantiation;

    public AbstractConstructorCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(33);
    }

    protected RfClass getFirstXVMParent(RfClass clazz) {
        RfClass parent = clazz.getParent();
        while (parent != null) {
            if (this.fOVMProject.isOVMElement(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void checkConstructorWithEmptyName(Map<String, RfClass> classes, boolean isComponent, boolean isObject, boolean emptyName) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        String libComponentName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component");
        for (RfClass classs : classes.values()) {
            int superNewMacroStackSize;
            String classFullName = "'" + LintUtils.getNamedElementFullName(classs) + "'";
            this.notifyCheckAlive();
            if (this.checkPreWaivers(classs.getFile())) continue;
            RfFunction constructor = classs.getConstructorWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
            if (constructor == null || constructor instanceof RfPredefinedFunction) {
                if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(classs.getDeclaration().getParserPath(), this)) continue;
                this.addHit(classs, String.valueOf(classFullName) + " constructor is missing!");
                continue;
            }
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(constructor.getDeclaration().getParserPath(), this)) continue;
            List<RfField> allConstructorArgs = constructor.getArgumentsWithPrefix("", 2);
            if (allConstructorArgs == null || allConstructorArgs.isEmpty()) {
                this.addHit(constructor, String.valueOf(classFullName) + " constructor doesn't have any arguments!");
                continue;
            }
            if (isComponent && allConstructorArgs.size() > 2 || !isComponent && allConstructorArgs.size() > 1) {
                this.addHit(constructor, String.valueOf(classFullName) + " constructor has more arguments than requested!");
                continue;
            }
            RfField nameArg = constructor.getArgumentWithPrefix("name", 1);
            if (nameArg == null) {
                this.addHit(constructor, String.valueOf(classFullName) + " constructor doesn't have an argument called 'name'!");
                continue;
            }
            if (nameArg.getDataType() != null && !"string".equals(nameArg.getDataType().getType())) {
                this.addHit(constructor, String.valueOf(classFullName) + " constructor's 'name' argument is not of type string!");
                continue;
            }
            if (isComponent) {
                List<RfField> parentArgs = constructor.getArgumentsWithPrefix("parent", 1);
                if (parentArgs == null || parentArgs.isEmpty()) {
                    this.addHit(constructor, String.valueOf(classFullName) + " constructor doesn't have an argument called 'parent'!");
                    continue;
                }
                if (!libComponentName.equals(parentArgs.get(0).getDataType().getType())) {
                    this.addHit(constructor, String.valueOf(classFullName) + " constructor's 'parent' argument is not of type " + libComponentName + "!");
                    continue;
                }
            }
            if (isComponent) {
                boolean anyInitialized = false;
                for (RfField arg : allConstructorArgs) {
                    if (arg.getInitialValue(false) == null) continue;
                    this.addHit(arg, String.valueOf(classFullName) + " constructor's argument '" + arg.getName() + "' should not have been initialized!");
                    anyInitialized = true;
                    break;
                }
                if (anyInitialized) {
                    continue;
                }
            } else {
                if (nameArg.getInitialValue(false) == null) {
                    this.addHit(nameArg, String.valueOf(classFullName) + " constructor's 'name' argument is not initialized!");
                    continue;
                }
                if (emptyName && !nameArg.getInitialValue(false).equals("\"\"")) {
                    this.addHit(nameArg, String.valueOf(classFullName) + " constructor's 'name' argument should be an empty string!");
                    continue;
                }
            }
            LocalRfHidVisitor visitor = new LocalRfHidVisitor(isComponent, classs, this);
            constructor.visitHidObject(this.fOVMProject.getRfProject(), visitor);
            if (!visitor.foundSuperNew) {
                this.addHit(constructor, String.valueOf(classFullName) + " constructor doesn't call super.new()!");
                continue;
            }
            ParserPath parserPath = constructor.getFile().getParserPath();
            int line = constructor.getLine();
            ReparseInfo reparseInfo = null;
            if (visitor.newOccurrence != null) {
                line = visitor.newOccurrence.getLine();
                if (visitor.newOccurrence.getReparseInfo() instanceof ReparseInfo) {
                    reparseInfo = (ReparseInfo)visitor.newOccurrence.getReparseInfo();
                }
            }
            if (!visitor.foundArguments) {
                this.addHit(parserPath, line, String.valueOf(classFullName) + " constructor's super.new() call doesn't pass any argument!", reparseInfo);
                continue;
            }
            if (!visitor.correctNofArgs) {
                this.addHit(parserPath, line, String.valueOf(classFullName) + " constructor's super.new() call passes more arguments than requested!", reparseInfo);
                continue;
            }
            if (!visitor.foundName) {
                this.addHit(parserPath, line, String.valueOf(classFullName) + " constructor's super.new() call doesn't pass 'name' as first argument!", reparseInfo);
                continue;
            }
            if (isComponent && !visitor.foundParent) {
                this.addHit(parserPath, line, String.valueOf(classFullName) + " constructor's super.new() call doesn't pass 'parent' as second argument!", reparseInfo);
                continue;
            }
            int constructorMacroStackSize = LintUtils.getMacroCallLevel(constructor);
            if (constructorMacroStackSize > 0) {
                this.addHit(constructor, String.valueOf(classFullName) + " constructor is defined through a macro!");
                continue;
            }
            if (reparseInfo != null && constructorMacroStackSize < (superNewMacroStackSize = reparseInfo.getReparseStackSize())) {
                this.addHit(parserPath, line, String.valueOf(classFullName) + " constructor's super.new() is called through a macro!", reparseInfo);
                continue;
            }
            if (this.pAllowAdditionalStatements) continue;
            int statementNo = constructor.getStatementNo();
            if (this.pAllowCoverageInstantiation && statementNo > 1) {
                statementNo -= visitor.coverageInstantiations;
            }
            if (this.fOVMProject.fCoverageCollectors.containsKey(classs.getFullName())) {
                int covergroupsConstructed = visitor.coverageInstantiations;
                if (covergroupsConstructed > 0 || statementNo <= covergroupsConstructed + 1) continue;
                this.addHit(constructor, String.valueOf(classFullName) + " constructor has more statements than requested!");
                continue;
            }
            if (statementNo <= 1) continue;
            if (!isComponent && !isObject) {
                int memberInitNo = this.getMemberInitializationNo(classs, constructor);
                if (statementNo <= memberInitNo + 1) continue;
                this.addHit(constructor, String.valueOf(classFullName) + " constructor has more statements than requested!");
                continue;
            }
            this.addHit(constructor, String.valueOf(classFullName) + " constructor has more statements than requested!");
        }
    }

    public void checkConstructor(Map<String, RfClass> classes, boolean isComponent, boolean isObject) {
        this.checkConstructorWithEmptyName(classes, isComponent, isObject, false);
    }

    private int getMemberInitializationNo(RfClass classs, RfFunction constructor) {
        int result = 0;
        ParserPath constructorParserPath = constructor.getFile().getParserPath();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(33);
        Set<ParserPath> parserPaths = allIssues.keySet();
        for (ParserPath parserPath : parserPaths) {
            List<SVTBIssues> issues;
            RfFileDef filedef;
            if (!constructorParserPath.equals((Object)parserPath) || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath)) == null || (issues = allIssues.get(parserPath)) == null || issues.isEmpty()) continue;
            for (SVTBIssues issue : issues) {
                List<RfField> fields;
                String leftValue;
                String referencedMemberName;
                String[] nameAndSelect;
                RfDefElement defScope = filedef.getScope(issue.getOffset(), true);
                RfNamedElement scope = defScope.getNamedElement();
                if (scope == null || !scope.equals(constructor) || (nameAndSelect = LintUtils.getNameAndSelect(referencedMemberName = this.getStringBeforeFirstDot(leftValue = issue.getInfo()))) == null || nameAndSelect.length != 2 || (fields = classs.getFieldsWithPrefix(nameAndSelect[0], 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || fields.isEmpty()) continue;
                ++result;
            }
        }
        return result;
    }

    private String getStringBeforeFirstDot(String name) {
        if (!name.contains(".")) {
            return name;
        }
        int index = 0;
        int openBrackets = 0;
        index = 0;
        while (index < name.length()) {
            char c = name.charAt(index);
            switch (c) {
                case '[': {
                    ++openBrackets;
                    break;
                }
                case ']': {
                    --openBrackets;
                    break;
                }
                case '.': {
                    if (openBrackets != 0) break;
                    return name.substring(0, index);
                }
            }
            ++index;
        }
        return name;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private final class LocalRfHidVisitor
    extends RfHidVisitor {
        private final boolean isComponent;
        public boolean foundSuperNew;
        public boolean foundArguments;
        public boolean correctNofArgs;
        public boolean foundName;
        public boolean foundParent;
        public int coverageInstantiations;
        private HidOccurrence newOccurrence;
        private RfClass scope;
        private OVMComplianceCheck check;

        private LocalRfHidVisitor(boolean isComponent, RfClass scope, OVMComplianceCheck check) {
            this.isComponent = isComponent;
            this.foundSuperNew = false;
            this.foundArguments = false;
            this.correctNofArgs = false;
            this.foundName = false;
            this.foundParent = false;
            this.newOccurrence = null;
            this.scope = scope;
            this.check = check;
            this.coverageInstantiations = 0;
        }

        public boolean visit(RfHid hidObject) {
            RfField scopeExtend = this.scope.getExtendedParameter();
            if (scopeExtend != null && scopeExtend.isTypeParameter() && hidObject.getName().equals("new") && hidObject.getElement() == null) {
                RfHid copy = (RfHid)hidObject.getAncestorHid().deepCopy();
                ConfigInfo configInfo = new ConfigInfo(false, AbstractConstructorCheck.this.fOVMProject.getRfProject(), null, true, null);
                try {
                    copy.resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), this.scope, this.scope, this.parserPath, RfTypesResolver.create((IRfScopeElement)this.scope, AbstractConstructorCheck.this.fOVMProject.getRfProject(), 6), null, (byte)3, true, false, false);
                }
                catch (BuildCancelException e) {
                    AbstractConstructorCheck.this.fOVMProject.notifyCheckException(this.check, (Exception)((Object)e));
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                copy.visitHidObject(AbstractConstructorCheck.this.fOVMProject.getRfProject(), this);
                return false;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!hidObject.getName().equals("new")) {
                return true;
            }
            this.checkIfCoverageConstructor(hidObject);
            Hid parentHid = hidObject.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement superElement = parentHid.getElement();
            if (!(superElement instanceof RfSuperImplicitVariable)) {
                return true;
            }
            this.foundSuperNew = true;
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            for (MethodCall methodCall : methodCalls) {
                this.newOccurrence = methodCall.occurrence;
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
                    return true;
                }
                this.foundArguments = true;
                Map argumentMap = methodCall.argumentValuesMapRaw;
                if (this.isComponent && argumentMap.size() > 2 || !this.isComponent && argumentMap.size() > 1) {
                    return true;
                }
                this.correctNofArgs = true;
                for (Map.Entry entry : argumentMap.entrySet()) {
                    IRfNamedElement valueElement;
                    IHidObject value = (IHidObject)entry.getValue();
                    if (!(value instanceof RfHid) || !((valueElement = ((RfHid)value).getElement()) instanceof RfField) || !((RfField)valueElement).isArgument()) continue;
                    if (valueElement.getName().equals("name")) {
                        this.foundName = true;
                        continue;
                    }
                    if (!this.isComponent || !valueElement.getName().equals("parent")) continue;
                    this.foundParent = true;
                }
            }
            return true;
        }

        private void checkIfCoverageConstructor(RfHid hidObject) {
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return;
            }
            RfFunction constructor = (RfFunction)element;
            RfNamedElement constructorScope = constructor.getEnclosingScope();
            if (!(constructorScope instanceof RfCovergroup)) {
                return;
            }
            ++this.coverageInstantiations;
        }
    }
}

