/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

public abstract class AbstractCreateVsNewCheck
extends OVMComplianceCheck {
    final boolean isOVMLib;
    final String fLibComponentsUtils;
    final String fLibComponentsUtilsBegin;
    final String fLibComponentsParamUtils;
    final String fLibObjectUtils;
    final String fLibObjectUtilsBegin;
    final String fLlibObjectParamUtils;
    final String[] fFactoryMacros;

    public AbstractCreateVsNewCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        this.fLibComponentsUtils = this.isOVMLib ? "`ovm_component_utils" : "`uvm_component_utils";
        this.fLibComponentsUtilsBegin = this.isOVMLib ? "`ovm_component_utils_begin" : "`uvm_component_utils_begin";
        this.fLibComponentsParamUtils = this.isOVMLib ? "`ovm_component_param_utils" : "`uvm_component_param_utils";
        this.fLibObjectUtils = this.isOVMLib ? "`ovm_object_utils" : "`uvm_object_utils";
        this.fLibObjectUtilsBegin = this.isOVMLib ? "`ovm_object_utils_begin" : "`uvm_object_utils_begin";
        this.fLlibObjectParamUtils = this.isOVMLib ? "`ovm_object_param_utils" : "`uvm_object_param_utils";
        this.fFactoryMacros = new String[]{this.fLibComponentsUtils, this.fLibComponentsUtilsBegin, this.fLibComponentsParamUtils, this.fLibObjectUtils, this.fLibObjectUtilsBegin, this.fLlibObjectParamUtils};
    }

    protected void checkCreateVersusNew() {
        RfClass createdType;
        RfNamedElement createdElem;
        for (RfFunctionCall create : this.fOVMProject.getAllCreateCalls()) {
            if (this.checkPreWaivers(create.getFile()) || (createdElem = create.getLeftValue()) == null || !(createdElem instanceof RfField) || (createdType = LintUtils.getFieldFinalClassTypeOrNull((RfField)createdElem)) == null || !this.checkType(createdType)) continue;
            this.addPassedHit(create, "'" + createdType.getName() + "' is created using create()!");
        }
        for (RfFunctionCall newCall : this.fOVMProject.getAllNewCalls()) {
            if (this.checkPreWaivers(newCall.getFile()) || newCall.isDynamicArrayNew() || (createdElem = newCall.getLeftValue()) == null || !(createdElem instanceof RfField) || (createdType = LintUtils.getFieldFinalClassTypeOrNull((RfField)createdElem, RfTypesResolver.create((IRfScopeElement)newCall.getEnclosingScope(), createdElem.getEnclosingScope().getRfProject(), 6))) == null || !this.checkType(createdType)) continue;
            this.addHit(newCall, "'" + createdType.getName() + "' is created using new()!");
        }
    }

    protected boolean isFactoryRegistered(RfClass classs) {
        MacroCallInfo macroInfo = classs.getMacroCallInfo();
        if (macroInfo != null) {
            List<MacroCallItem> allMacrosUsed = macroInfo.getItems();
            if (allMacrosUsed == null) {
                return false;
            }
            for (MacroCallItem item : allMacrosUsed) {
                int i = 0;
                while (i < this.fFactoryMacros.length) {
                    if (this.fFactoryMacros[i].equals(item.getName())) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected abstract boolean checkType(RfClass var1);

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

