/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.guidelines.FormatStringVisitor;
import ro.amiq.vlogdt.linter.guidelines.FoundModification;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class AbstractCreatedInstanceNameCheck
extends OVMComplianceCheck {
    private static final String HIT_MESSAGE_FORMAT = "The creation of ''{0}'' does not use the {1} instance name!";
    private static final String ARRAY_NAME_IDENTIFIER = "$identifier";
    private static final String ARRAY_NAME_INDEX = "$index";
    private static final String WORD = "%[0-9]*[a-kn-zA-KN-Z]";
    private static final Pattern ARRAY_NAME_INDEX_PATTERN = Pattern.compile(Pattern.quote("$index"));
    @CheckParameter(defaultValue="$psprintf,$sformatf", description="Comma separated list of allowed print functions.When instantiating arrays, the name may be obtained by adding the index to the instance name using an 'allowedPrintFunction'.", name="allowedPrintFunctions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedPrintFunctionsValue;
    @CheckParameter(defaultValue="false", description="When true, associative array fields are skiped.", name="skipAssociativeArrayFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipAssociativeArrayFields;
    @CheckParameter(defaultValue="", description="Comma separated list patterns for the array element creation name. The patterns must contain $identifier and $index.\nExample:\n$identifier_$index\n", name="arrayNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pArrayNamePattern;

    protected AbstractCreatedInstanceNameCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pArrayNamePattern != null && !this.pArrayNamePattern.isEmpty()) {
            for (String pattern : this.pArrayNamePattern) {
                if (!pattern.contains(ARRAY_NAME_IDENTIFIER)) {
                    this.signalParamError("Invalid value: " + pattern + " for 'arrayNamePattern' parameter because it does not contain '" + ARRAY_NAME_IDENTIFIER + "'!", true);
                    return;
                }
                if (!pattern.contains(ARRAY_NAME_INDEX)) {
                    this.signalParamError("Invalid value: " + pattern + " for 'arrayNamePattern' parameter because it does not contain '" + ARRAY_NAME_INDEX + "'!", true);
                    return;
                }
                try {
                    String regex = pattern.replace(ARRAY_NAME_IDENTIFIER, "\\w+");
                    regex = DVTStringUtil.replaceAll((Pattern)ARRAY_NAME_INDEX_PATTERN, (CharSequence)pattern, (String)"\\w+");
                    Pattern.compile(regex);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.signalParamError("Invalid value: " + pattern + " for 'arrayNamePattern' parameter because it is not a valid regex!", true);
                    return;
                }
            }
        }
    }

    protected void checkCreatedInstanceName(Map<String, RfClass> checkOnlyClasses, String fieldTypeInfoMsg) {
        this.checkCreatedInstanceNameInParentClasses(checkOnlyClasses, null, null, fieldTypeInfoMsg, false, null, false);
    }

    protected void checkCreatedInstanceNameInParentClasses(Map<String, RfClass> checkOnlyClasses, Map<String, RfClass> checkOnlyInsideClasses, Set<String> ignoredHandles, String fieldTypeInfoMsg, boolean ignoreHierarchicalHandles, Pattern suffixPattern, boolean allowConcatenation) {
        FormatStringVisitor visitor = new FormatStringVisitor(this.fOVMProject, this);
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        Map<ParserPath, List<RfHidOperator>> allCreateCalls = visitor.getAllCreateCalls();
        Map<RfHidOperator, RfField> declaratedFields = visitor.getDeclaratedFields();
        for (Map.Entry<ParserPath, List<RfHidOperator>> entry : allCreateCalls.entrySet()) {
            this.notifyCheckAlive();
            ParserPath parserPath = entry.getKey();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.fOVMProject.getRfProject().getFile(parserPath);
            List<RfHidOperator> createCalls = entry.getValue();
            RfFileDef filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
            for (RfHidOperator op : createCalls) {
                HidAccess parentAccess;
                IRfNamedElement el;
                IHidObject createCallFirstArgument;
                List<RfFunction> leftValueFieldTypeAsClassConstructor;
                RfNamedElement leftValueFieldType;
                RfNamedElement leftValueElementEnclosingScope;
                int selects = 0;
                IRfScopeElement scope = filedef.getScope(op.getOffset());
                IHidObject lhValue = op.getLHValue();
                if (lhValue instanceof RfHidAccess) {
                    selects = ((RfHidAccess)lhValue).getSelects().size();
                    lhValue = ((RfHidAccess)lhValue).getParentHid();
                }
                if (!(lhValue instanceof RfHid) && !(lhValue instanceof RfHidImplicit)) continue;
                IRfNamedElement element = null;
                if (lhValue instanceof RfHid) {
                    RfHid lhHid = (RfHid)lhValue;
                    if (ignoreHierarchicalHandles && lhHid.getParentAccess() != null) continue;
                    element = lhHid.getElement();
                }
                if (lhValue instanceof RfHidImplicit && (element = (IRfNamedElement)declaratedFields.get(op)) != null && ((RfField)element).getDataType() != null && ((RfField)element).getDataType().getUnpackedDimension() != null) {
                    selects = ((RfField)element).getDataType().getUnpackedDimension().size();
                }
                if (!(element instanceof RfField) || ignoredHandles != null && ignoredHandles.contains(element.getName()) || (leftValueElementEnclosingScope = ((RfField)element).getEnclosingScope()) == null || !(leftValueElementEnclosingScope instanceof RfClass) || checkOnlyInsideClasses != null && !checkOnlyInsideClasses.containsKey(leftValueElementEnclosingScope.getFullName()) || (leftValueFieldType = LintUtils.getAssociatedFinalType((RfField)element, RfTypesResolver.create(scope, this.fOVMProject.getRfProject(), 14))) == null) continue;
                RfClass leftValueFieldTypeAsClass = null;
                if (leftValueFieldType instanceof RfClass) {
                    leftValueFieldTypeAsClass = (RfClass)leftValueFieldType;
                } else {
                    if (!(leftValueFieldType instanceof RfListType)) continue;
                    leftValueFieldTypeAsClass = LintUtils.getFieldFinalClassTypeOrNull((RfField)element);
                }
                if (leftValueFieldTypeAsClass == null || checkOnlyClasses != null && !checkOnlyClasses.containsKey(leftValueFieldTypeAsClass.getFullName()) || this.pSkipAssociativeArrayFields && ((RfField)element).isAssociativeArray() || (leftValueFieldTypeAsClassConstructor = leftValueFieldTypeAsClass.getConstructorsWithPrefix("new", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || leftValueFieldTypeAsClassConstructor.isEmpty()) continue;
                boolean constructorWithFirstArgumentNameFound = false;
                for (RfFunction constructor : leftValueFieldTypeAsClassConstructor) {
                    List<RfField> nameArgs = constructor.getArgumentsWithPrefix("name", 1);
                    if (nameArgs == null || nameArgs.isEmpty()) continue;
                    constructorWithFirstArgumentNameFound = true;
                    break;
                }
                if (!constructorWithFirstArgumentNameFound || HidUtils.isHidAccess((IHidObject)(createCallFirstArgument = (IHidObject)op.getRHValues().get(0))) && RfListType.isDynamicArray((IRfScopeElement)((HidAccess)createCallFirstArgument).getAssociatedType())) continue;
                MethodCall methodCall = null;
                if (createCallFirstArgument instanceof RfHidAccessArgs) {
                    methodCall = ((RfHidAccessArgs)createCallFirstArgument).getMethodCall();
                }
                if (createCallFirstArgument instanceof RfHid && (el = ((RfHid)createCallFirstArgument).getElement()) instanceof RfFunction) {
                    methodCall = MethodCallUtils.getMethodCall((IHidObject)createCallFirstArgument, (IRfNamedElement)el, null, null, (boolean)false, null);
                }
                if (methodCall == null || !(methodCall.method instanceof RfFunction)) {
                    this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
                    continue;
                }
                if (createCallFirstArgument instanceof RfHid && methodCall.method.getName().equals("new") && ((RfHid)createCallFirstArgument).getElement() instanceof RfPredefinedFunction && (parentAccess = ((RfHid)createCallFirstArgument).getParentAccess()) instanceof RfHidAccess && !(parentAccess.getAssociatedType() instanceof RfClass)) continue;
                if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) {
                    this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
                    continue;
                }
                RfField createCallNameArgument = ((RfFunction)methodCall.method).getArgumentWithPrefix("name", 1);
                IHidObject rawActualValue = (IHidObject)methodCall.argumentValuesMapRaw.get(createCallNameArgument);
                if (HidUtils.isOperator((IHidObject)rawActualValue) && ((HidOperator)rawActualValue).isVLOGConcatenation(true)) {
                    if (!allowConcatenation) {
                        this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
                        continue;
                    }
                    ListContainer values = ((HidOperator)rawActualValue).getRHValues();
                    if (values == null || values.isEmpty()) continue;
                    String result = "\"";
                    boolean onlyExplicitValues = true;
                    for (IHidObject value : values) {
                        if (!(value instanceof RfHidImplicit)) {
                            onlyExplicitValues = false;
                            break;
                        }
                        String name = ((RfHidImplicit)value).getName();
                        if (name.startsWith("\"")) {
                            name = name.substring(1);
                        }
                        if (name.endsWith("\"")) {
                            name = name.substring(0, name.length() - 1);
                        }
                        result = String.valueOf(name) + result;
                    }
                    if (!onlyExplicitValues) {
                        this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
                        continue;
                    }
                    if (this.areEqual(result = "\"" + result, element.getName(), selects, null, suffixPattern)) continue;
                    this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
                    continue;
                }
                Set value = (Set)methodCall.argumentValuesMap.get(createCallNameArgument);
                if (value == null || value.isEmpty()) {
                    this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
                    continue;
                }
                Iterator argumentValuesIterator = value.iterator();
                boolean found = false;
                while (argumentValuesIterator.hasNext()) {
                    RfNamedElement variableDeclarationScope;
                    IRfDefElement declaration;
                    IHid val = (IHid)argumentValuesIterator.next();
                    if (val instanceof RfHidImplicit) {
                        if (!this.areEqual(val.getName(), element.getName(), selects, null, suffixPattern)) continue;
                        found = true;
                        continue;
                    }
                    if (!(val instanceof RfHid)) continue;
                    if (val.getElement() instanceof RfPredefinedFunction) {
                        if (!val.getElement().getName().equals("$sformatf") && !val.getElement().getName().equals("$psprintf") || !this.pAllowedPrintFunctionsValue.contains(val.getElement().getName())) {
                            this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
                            break;
                        }
                        Iterator argumentValuesIteratorCopy = value.iterator();
                        argumentValuesIteratorCopy.next();
                        IHid formatString = (IHid)argumentValuesIteratorCopy.next();
                        ArrayList<IHid> argumentList = new ArrayList<IHid>();
                        while (argumentValuesIteratorCopy.hasNext()) {
                            argumentList.add((IHid)argumentValuesIteratorCopy.next());
                        }
                        found = this.areEqual(formatString.getName(), element.getName(), selects, argumentList, suffixPattern);
                        if (found) break;
                        this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
                        break;
                    }
                    if (!(val.getElement() instanceof RfField)) continue;
                    IRfScopeElement createCallScope = filedef.getScope(op.getOccurrence().getOffset());
                    if (!(createCallScope instanceof RfDefElement) || (createCallScope = ((RfDefElement)createCallScope).getNamedElement()) == null || !((declaration = val.getElement().getDeclaration()) instanceof RfDefElement) || (variableDeclarationScope = ((RfDefElement)declaration).getNamedElement().getEnclosingScope()) == null) break;
                    FoundModification foundModification = new FoundModification((RfField)val.getElement(), op.getOccurrence());
                    while (createCallScope instanceof RfNamedElement && ((RfNamedElement)createCallScope).getHidHolder() != null) {
                        ((RfNamedElement)createCallScope).getHidHolder().visitHidObject(null, foundModification);
                        if (foundModification.getAssignModification() == null && foundModification.getSformatModification() == null && !createCallScope.equals(variableDeclarationScope) && (createCallScope = createCallScope.getEnclosingScope()) != null) continue;
                    }
                    RfHidOperator assignModification = foundModification.getAssignModification();
                    MethodCall sformatModification = foundModification.getSformatModification();
                    if (assignModification != null && sformatModification != null) {
                        if (assignModification.getOccurrence().getOffset() < sformatModification.occurrence.getOffset()) {
                            assignModification = null;
                        } else {
                            sformatModification = null;
                        }
                    }
                    if (assignModification != null) {
                        IHidObject iHidObject = (IHidObject)assignModification.getRHValues().get(0);
                        if (iHidObject instanceof RfHidImplicit) {
                            if (!this.areEqual(((RfHidImplicit)iHidObject).getName(), element.getName(), selects, null, suffixPattern)) continue;
                            found = true;
                            break;
                        }
                        if (!(iHidObject instanceof RfHidAccessArgs)) continue;
                        MethodCall m = ((RfHidAccessArgs)iHidObject).getMethodCall();
                        found = this.evaluateMethodCall(m, (RfField)element, selects, suffixPattern);
                        continue;
                    }
                    if (sformatModification == null) continue;
                    found = this.evaluateMethodCall(sformatModification, (RfField)element, selects, suffixPattern);
                }
                if (found) continue;
                this.addHit(parserPath, (HidOccurrence)op.getOccurrence(), MessageFormat.format(HIT_MESSAGE_FORMAT, ((RfField)element).getName(), fieldTypeInfoMsg), new VerissimoAutofixAdditionalInfo(element, op));
            }
        }
    }

    private boolean evaluateMethodCall(MethodCall methodCall, RfField element, int selects, Pattern suffixPattern) {
        if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
            return false;
        }
        for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
            IHidObject value = (IHidObject)argument.getValue();
            if (!(value instanceof RfHidImplicit) || !this.areEqual(((RfHidImplicit)value).getName(), element.getName(), selects, null, suffixPattern)) continue;
            return true;
        }
        return false;
    }

    private boolean areEqual(String argument, String element, int selects, ArrayList<IHid> argumentList, Pattern suffixPattern) {
        int firstCharAfterAdditionalSuffix;
        String endString;
        String startString;
        String patternWithoutAdditionalSuffix;
        if (selects == 0) {
            patternWithoutAdditionalSuffix = "^\"" + element + "\"$";
            startString = "\"" + element;
            endString = "\"";
            firstCharAfterAdditionalSuffix = 34;
        } else {
            patternWithoutAdditionalSuffix = "^\"" + element + "(\\[[^\\]]*\\]){" + selects + "}\"$";
            startString = "\"" + element;
            endString = "(\\[[^\\]]*\\]){" + selects + "}\"$";
            firstCharAfterAdditionalSuffix = 91;
        }
        if (suffixPattern == null || suffixPattern.pattern() == null || suffixPattern.pattern().isEmpty()) {
            if (selects != 0 && !this.pArrayNamePattern.isEmpty()) {
                boolean result = false;
                for (String pattern : this.pArrayNamePattern) {
                    Pattern arrayNamePattern;
                    try {
                        String regex = pattern.replace(ARRAY_NAME_IDENTIFIER, element);
                        regex = DVTStringUtil.replaceAll((Pattern)ARRAY_NAME_INDEX_PATTERN, (CharSequence)regex, (String)WORD);
                        arrayNamePattern = Pattern.compile("\"" + regex + "\"");
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        this.signalParamError("Invalid value: " + pattern + " for 'arrayNamePattern' parameter because it is not a valid regex!", false);
                        return false;
                    }
                    if (!arrayNamePattern.matcher(argument).matches()) continue;
                    result = true;
                    break;
                }
                return result;
            }
            return argument.matches(patternWithoutAdditionalSuffix);
        }
        if (!argument.matches(String.valueOf(startString) + ".*" + endString)) {
            return false;
        }
        String additionalSuffix = argument.substring(startString.length(), argument.indexOf(firstCharAfterAdditionalSuffix, startString.length()));
        return this.checkSuffix(additionalSuffix, suffixPattern, argumentList);
    }

    private boolean checkSuffix(String suffix, Pattern suffixPattern, ArrayList<IHid> argumentList) {
        if (suffix == null || suffix.isEmpty()) {
            return true;
        }
        if (suffixPattern == null || suffixPattern.pattern() == null || suffixPattern.pattern().isEmpty()) {
            return false;
        }
        if (argumentList == null || argumentList.isEmpty()) {
            return suffix.matches(suffixPattern.pattern());
        }
        int argumentIndex = 0;
        String expandedSuffix = "";
        int index = 0;
        while (index < suffix.length()) {
            char currentChar = suffix.charAt(index);
            if (currentChar != '%') {
                expandedSuffix = String.valueOf(expandedSuffix) + currentChar;
            } else {
                String currentFormat = "%";
                int index2 = index + 1;
                while (index2 < suffix.length()) {
                    currentFormat = String.valueOf(currentFormat) + suffix.charAt(index2);
                    if (LintUtilsConstants.FORMAT_SPECIFIERS.contains(Character.valueOf(suffix.charAt(index2)))) break;
                    ++index2;
                }
                if (argumentIndex >= argumentList.size()) {
                    return false;
                }
                IHid arg = argumentList.get(argumentIndex);
                if (arg instanceof RfHidImplicit) {
                    String name = ((RfHidImplicit)arg).getName();
                    if (name.startsWith("\"")) {
                        name = name.substring(1);
                    }
                    if (name.endsWith("\"")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    expandedSuffix = String.valueOf(expandedSuffix) + name;
                } else {
                    expandedSuffix = String.valueOf(expandedSuffix) + currentFormat;
                }
                ++argumentIndex;
                index += currentFormat.length() - 1;
            }
            ++index;
        }
        return expandedSuffix.matches(suffixPattern.pattern());
    }
}

