/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Collection;
import java.util.Comparator;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractDeclarationOrderCheck
extends OVMComplianceCheck {
    protected static final Comparator<Object> COMPARATOR = (o1, o2) -> {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 == o2) {
            return 0;
        }
        return Integer.valueOf(AbstractDeclarationOrderCheck.getLine(o1)).compareTo(AbstractDeclarationOrderCheck.getLine(o2));
    };

    protected AbstractDeclarationOrderCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected HitElement checkDeclarationOrder(Collection<Object> declarations) {
        if (declarations.size() > 1) {
            Object[] declarationsArray = declarations.toArray();
            Object previous = declarationsArray[0];
            int i = 1;
            while (i < declarationsArray.length) {
                Object current = declarationsArray[i];
                if (AbstractDeclarationOrderCheck.getLine(current) <= AbstractDeclarationOrderCheck.getLine(previous)) {
                    return new HitElement(current, previous);
                }
                previous = current;
                ++i;
            }
        }
        return null;
    }

    protected static String getName(Object obj) {
        if (obj instanceof MacroCallItem) {
            return ((MacroCallItem)obj).getName();
        }
        if (obj instanceof RfFunctionCall) {
            String lValue = ((RfFunctionCall)obj).getLValue();
            String name = ((RfFunctionCall)obj).getName();
            if (lValue == null || "".equals(lValue)) {
                return name;
            }
            return String.valueOf(lValue) + " = " + name;
        }
        if (obj instanceof RfNamedElement) {
            return ((RfNamedElement)obj).getName();
        }
        if (obj instanceof DummyElement) {
            return ((DummyElement)obj).name;
        }
        if (obj instanceof ImportInfo) {
            return ((ImportInfo)obj).getPackageName();
        }
        return "";
    }

    protected static int getLine(Object obj) {
        if (obj instanceof MacroCallItem) {
            return ((MacroCallItem)obj).getLineNumber();
        }
        if (obj instanceof RfNamedElement) {
            return ((RfNamedElement)obj).getLine();
        }
        if (obj instanceof DummyElement) {
            return ((DummyElement)obj).line;
        }
        if (obj instanceof ImportInfo) {
            return ((ImportInfo)obj).getLine();
        }
        return 0;
    }

    protected static ParserPath getParserPath(Object obj) {
        if (obj instanceof MacroCallItem) {
            return ((MacroCallItem)obj).getParserPath();
        }
        if (obj instanceof RfNamedElement) {
            return ((RfNamedElement)obj).getFile().getParserPath();
        }
        if (obj instanceof DummyElement) {
            return ((DummyElement)obj).parserPath;
        }
        if (obj instanceof ImportInfo) {
            return ((ImportInfo)obj).getParserPath();
        }
        return new ParserPath("");
    }

    protected static ReparseInfo getReparseInfo(Object obj) {
        if (obj instanceof MacroCallItem) {
            return ((MacroCallItem)obj).getReparseInfo();
        }
        if (obj instanceof RfNamedElement) {
            return ((RfNamedElement)obj).getDeclaration().getReparseInfo();
        }
        if (obj instanceof DummyElement) {
            return ((DummyElement)obj).reparseInfo;
        }
        return null;
    }

    protected static class DummyElement {
        String name;
        int line;
        ParserPath parserPath;
        ReparseInfo reparseInfo;

        public DummyElement(String name, int line, ParserPath parserPath, ReparseInfo reparseInfo) {
            this.name = name;
            this.line = line;
            this.parserPath = parserPath;
            this.reparseInfo = reparseInfo;
        }

        public String toString() {
            return String.valueOf(this.name) + " @" + this.line + " in " + this.parserPath.toString();
        }

        public int getLine() {
            return this.line;
        }
    }

    protected static class HitElement {
        Object current;
        Object previous;

        public HitElement(Object current, Object previous) {
            this.current = current;
            this.previous = previous;
        }

        public Object getCurrent() {
            return this.current;
        }

        public Object getPrevious() {
            return this.previous;
        }
    }
}

