/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

public abstract class AbstractDeclaredClassElementsCheck
extends OVMComplianceCheck {
    protected AbstractDeclaredClassElementsCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    public void performCheck(Set<RfClass> baseClasses, HashSet<String> skipClasses, HashSet<String> elementKind) {
        if (baseClasses == null || baseClasses.isEmpty()) {
            return;
        }
        this.checkClasses(new HashSet<RfClass>(), baseClasses, skipClasses, elementKind);
    }

    private void checkClasses(Set<RfClass> visited, Collection<RfClass> classes, HashSet<String> skipClasses, HashSet<String> elementKind) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        for (RfClass clazz : classes) {
            if (visited.contains(clazz)) continue;
            this.notifyCheckAlive();
            visited.add(clazz);
            if (skipClasses != null && skipClasses.contains(clazz.getFullName())) continue;
            this.checkClasses(visited, clazz.getChildren(), skipClasses, elementKind);
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getFile().getParserPath(), this)) continue;
            this.checkDeclaredElementsInClass(clazz, elementKind);
        }
    }

    private void checkDeclaredElementsInClass(final RfClass clazz, final HashSet<String> elementKind) {
        if (clazz == null) {
            return;
        }
        clazz.accept(this.fOVMProject.getRfProject(), new IRfNamedElementVisitor(){
            Set<String> visitedStructs = new HashSet<String>();

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean visit(RfNamedElement namedElement) {
                void field;
                RfNamedElement rfNamedElement;
                IRfNamedElement associatedType;
                if (namedElement.isPredefined()) {
                    return true;
                }
                String namedElementKind = LintUtils.getElementKind(namedElement);
                if (namedElementKind == null || !elementKind.contains(namedElementKind)) {
                    return true;
                }
                if (!AbstractDeclaredClassElementsCheck.this.checkEnclosingScope(clazz, namedElement.getEnclosingScope())) {
                    return true;
                }
                if (namedElement instanceof RfTypeAlias) {
                    associatedType = ((RfAssociatedType)namedElement).getAssociatedType();
                    if (associatedType instanceof RfStruct && this.visitedStructs.contains(associatedType.getName())) {
                        return true;
                    }
                } else if (namedElement instanceof RfStruct) {
                    this.visitedStructs.add(namedElement.getName());
                }
                if ((rfNamedElement = namedElement) instanceof RfField && (associatedType = (RfField)rfNamedElement) == (RfField)rfNamedElement && field.isFromEmbeddedCovergroupDef()) {
                    return true;
                }
                AbstractDeclaredClassElementsCheck.this.addHit(namedElement, AbstractDeclaredClassElementsCheck.this.getHitMessage(namedElement, clazz));
                return true;
            }
        });
        this.getCoverGroupInstantiation(clazz);
    }

    private boolean checkEnclosingScope(RfNamedElement clazz, RfNamedElement enclosingScope) {
        if (enclosingScope == null || enclosingScope instanceof RfLibrary) {
            return false;
        }
        if (this.checkInnerClasses(clazz, enclosingScope)) {
            return false;
        }
        if (clazz.equals(enclosingScope)) {
            return true;
        }
        return this.checkEnclosingScope(clazz, enclosingScope.getEnclosingScope());
    }

    public abstract boolean checkInnerClasses(RfNamedElement var1, RfNamedElement var2);

    public abstract void getCoverGroupInstantiation(RfClass var1);

    public abstract String getHitMessage(RfNamedElement var1, RfNamedElement var2);
}

