/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

public abstract class AbstractDoPackUnpackMembersCheck
extends OVMComplianceCheck {
    String fMethodName = null;

    public AbstractDoPackUnpackMembersCheck(OVMProject oVMProject, OVMComplianceCategory category, String methodName) {
        super(oVMProject, category);
        this.fMethodName = methodName;
    }

    @Override
    public void performCheckImpl() {
        String ovm_uvm_object = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
        NullProtectedList<RfNamedElement> allFunctions = this.fOVMProject.getAllFunctions();
        for (RfNamedElement function : allFunctions) {
            RfNamedElement container;
            if (!this.fMethodName.equals(function.getName())) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(function.getFile()) || (container = function.getClosestTypeContainer()) == null || !(container instanceof RfClass) || !((RfClass)container).isSubClass(ovm_uvm_object, true)) continue;
            List<RfField> fields = container.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            this.checkMembers((RfFunction)function, fields);
        }
    }

    protected abstract void checkMembers(RfFunction var1, List<RfField> var2);

    protected void checkAllMembersInDoPackUnpack(RfFunction method, List<RfField> fields) {
        boolean isPack = "do_pack".equals(method.getName());
        NullProtectedList<RfField> unreferredFields = new NullProtectedList<RfField>();
        for (RfField field : fields) {
            if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field)) continue;
            unreferredFields.add(field);
        }
        List<RfField> packerCandidates = method.getArgumentsWithPrefix("", 2);
        String libComparerName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_packer");
        if (packerCandidates == null || packerCandidates.isEmpty()) {
            this.addHitOnFunctionDefinition(method, String.valueOf(method.getName()) + " method doesn't have a " + libComparerName + " argument");
            return;
        }
        RfNamedElement packer = null;
        for (RfField argument : packerCandidates) {
            if (argument.getDataType() == null || !libComparerName.equals(argument.getDataType().getType())) continue;
            packer = argument;
        }
        if (packer == null) {
            this.addHitOnFunctionDefinition(method, String.valueOf(method.getName()) + " method doesn't have a " + libComparerName + " argument");
            return;
        }
        String packerMethodStartName = isPack ? ".pack_" : ".unpack_";
        List<RfFunctionCall> allPackerCalls = method.getFunctionCallsWithPrefix(String.valueOf(packer.getName()) + packerMethodStartName, 2);
        List<RfFunctionCall> allFieldCalls = method.getFunctionCallsWithPrefix("", 2);
        for (RfField field : fields) {
            if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || !unreferredFields.contains(field)) continue;
            boolean isChecked = false;
            isChecked = isPack ? this.checkFieldInDoPack(field, allFieldCalls, allPackerCalls) : this.checkFieldInDoUnPack(field, allFieldCalls, allPackerCalls);
            if (!isChecked) continue;
            unreferredFields.remove(field);
        }
        if (unreferredFields.isEmpty()) {
            this.addPassedHit(method, String.valueOf(method.getName()) + " method includes all member variables");
        } else {
            for (RfField field : unreferredFields) {
                this.addHit(field, String.valueOf(method.getName()) + " method doesn't include: '" + field.getName() + "'");
            }
        }
    }

    protected boolean checkFieldInDoPack(RfField field, List<RfFunctionCall> allFieldCalls, List<RfFunctionCall> allPackerCalls) {
        for (RfFunctionCall aFieldCall : allFieldCalls) {
            if (!aFieldCall.getName().equals(field.getName()) && !aFieldCall.getName().startsWith(String.valueOf(field.getName()) + ".") && !aFieldCall.getName().startsWith(String.valueOf(field.getName()) + "[")) continue;
            for (RfFunctionCall comparerCall : allPackerCalls) {
                if (!aFieldCall.isInsideAnotherFunctionCall(comparerCall)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkFieldInDoUnPack(RfField field, List<RfFunctionCall> allFieldCalls, List<RfFunctionCall> allPackerCalls) {
        for (RfFunctionCall comparerCall : allPackerCalls) {
            if (!field.getName().equals(comparerCall.getLValue())) continue;
            return true;
        }
        for (RfFunctionCall aFieldCall : allFieldCalls) {
            if (!aFieldCall.getName().equals(field.getName()) && !aFieldCall.getName().startsWith(String.valueOf(field.getName()) + ".") && !aFieldCall.getName().startsWith(String.valueOf(field.getName()) + "[")) continue;
            for (RfFunctionCall comparerCall : allPackerCalls) {
                if (!aFieldCall.isInsideAnotherFunctionCall(comparerCall)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

