/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.parser.MacroCallItem;

public abstract class AbstractFactoryMacroCheck
extends OVMComplianceCheck {
    public AbstractFactoryMacroCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    boolean checkFactoryMacroInClass(RfClass aRfClass, String aExpectedMacro, boolean checkFirstArgument, boolean checkParameterizedArgumentsValue, boolean checkLayeredMacroCalls) {
        if (aRfClass == null || aExpectedMacro == null) {
            return false;
        }
        List<MacroCallItem> allMacroCallsInClass = this.fOVMProject.getAllMacroCallsInClass(aRfClass);
        if (allMacroCallsInClass == null || allMacroCallsInClass.isEmpty()) {
            return false;
        }
        for (MacroCallItem macroCallItem : allMacroCallsInClass) {
            if (macroCallItem == null || !checkLayeredMacroCalls && macroCallItem.getReparseInfo() != null && macroCallItem.getReparseInfo().getReparseStackSize() > 0 || !aExpectedMacro.equals(macroCallItem.getName())) continue;
            if (!checkFirstArgument) {
                this.addPassedHit(macroCallItem.getParserPath(), macroCallItem.getLineNumber(), "Expected macro '" + aExpectedMacro + "' exists!", macroCallItem.getReparseInfo());
            } else {
                String info = this.fOVMProject.isFirstMacroArgumentTheClass(macroCallItem, aRfClass, checkParameterizedArgumentsValue, LintUtils.getValidTypedefsForMacroRegistration(aRfClass));
                if (info == null) {
                    this.addPassedHit(macroCallItem.getParserPath(), macroCallItem.getLineNumber(), "Expected macro '" + aExpectedMacro + "' exists!", macroCallItem.getReparseInfo());
                } else {
                    this.addHit(macroCallItem.getParserPath(), macroCallItem.getLineNumber(), "Incorrect first argument of macro '" + aExpectedMacro + "'! " + info, macroCallItem.getReparseInfo());
                }
            }
            return true;
        }
        return false;
    }
}

