/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsBeginEndMacroCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;

public abstract class AbstractFactoryRegistrationMacros
extends AbstractUtilsBeginEndMacroCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of base classes for whose children it is allowed to use `xvm_component_utils instead of `xvm_component_param_utils.", name="allowNonParamUtilsForBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pAllowNonParamUtilsForBaseClasses;
    protected Set<String> libUtils;
    protected Set<String> libParamUtils;
    protected Set<String> libUtilsBegin;
    protected String libUtilsEnd;
    protected Set<String> libParamUtilsBegin;

    public AbstractFactoryRegistrationMacros(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> allElementsMap = this.getElementsMap();
        if (allElementsMap.isEmpty()) {
            return;
        }
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        this.setLibUtils(isOVMLib);
        HashMap<String, RfClass> exceptionedElementsMap = new HashMap<String, RfClass>();
        if (this.pAllowNonParamUtilsForBaseClasses != null && !this.pAllowNonParamUtilsForBaseClasses.isEmpty()) {
            Iterator<Map.Entry<String, RfClass>> iterator = allElementsMap.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                RfClass clazz;
                this.notifyCheckAlive();
                Map.Entry<String, RfClass> entry = iterator.next();
                RfClass parent = clazz = entry.getValue();
                while (parent != null) {
                    if (this.pAllowNonParamUtilsForBaseClasses.contains(parent.getFullName())) {
                        exceptionedElementsMap.put(entry.getKey(), entry.getValue());
                        iterator.remove();
                        continue block0;
                    }
                    parent = parent.getParent();
                }
            }
            if (!exceptionedElementsMap.isEmpty()) {
                this.checkMacros(exceptionedElementsMap, this.libUtils, this.libParamUtils, this.libUtilsBegin, this.libUtilsEnd, this.libParamUtilsBegin, true, true);
            }
        }
        this.checkMacros(allElementsMap, this.libUtils, this.libParamUtils, this.libUtilsBegin, this.libUtilsEnd, this.libParamUtilsBegin, true, false);
    }

    protected abstract void setLibUtils(boolean var1);

    protected abstract Map<String, RfClass> getElementsMap();
}

