/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

public abstract class AbstractInfoMacroCheck
extends OVMComplianceCheck {
    protected HashSet<String> bannedVerbosity;
    protected String XVM_INFO;
    protected boolean onlyInLoop;
    private static final HashSet<String> UVM_MACRO_CALLS = new HashSet();
    private static final HashSet<String> OVM_MACRO_CALLS = new HashSet();
    private HashSet<String> fMacroCalls;
    @CheckParameter(defaultValue="false", description="When true method calls or `xvm_info macro calls that are guarded by an if (get_report_verbosity_level == xvm_verbosity_value) will not be reported. Only the existence of the get_report_verbosity_level method call in the if expression is checked.", name="allowedWithVerbosityLevelGuard", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowWithVerbosityLevelGuard;

    static {
        OVM_MACRO_CALLS.add("`ovm_info");
        UVM_MACRO_CALLS.add("`uvm_info");
    }

    protected AbstractInfoMacroCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.bannedVerbosity = new HashSet<String>(Arrays.asList(OVMUtils.prependCapitalizedLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_NONE")));
        this.XVM_INFO = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_info");
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        this.fMacroCalls = isOVMLib ? OVM_MACRO_CALLS : UVM_MACRO_CALLS;
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("all", this.fMacroCalls);
    }

    protected Set<MacroCallItem> getInvalidMacroCallItems(MacroCallInfo macroCallInfo) {
        HashSet<MacroCallItem> result = new HashSet<MacroCallItem>();
        if (macroCallInfo == null) {
            return result;
        }
        List<MacroCallItem> macroCallItems = LintUtils.getMacroCallsInSet(macroCallInfo, this.fMacroCalls);
        if (macroCallItems == null) {
            return result;
        }
        for (MacroCallItem macroCallItem : macroCallItems) {
            if (!this.bannedVerbosity.contains(macroCallItem.getMacroParameters()[2]) || this.onlyInLoop && !this.isInLoop(macroCallItem)) continue;
            if (!this.pAllowWithVerbosityLevelGuard) {
                result.add(macroCallItem);
                continue;
            }
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(macroCallItem.getParserPath());
            if (fileDef == null) {
                result.add(macroCallItem);
                continue;
            }
            RfDefElement defScope = fileDef.getScope(macroCallItem.getLineInfo().realOffset - 1, true);
            if (defScope == null) {
                result.add(macroCallItem);
                continue;
            }
            RfNamedElement enclosingScope = defScope.getNamedElement();
            if (enclosingScope instanceof RfActionBlock && ((RfAbstractBlock)enclosingScope).isConditional() && this.isValidConditionOfActionBlock((RfActionBlock)enclosingScope)) continue;
            result.add(macroCallItem);
        }
        return result;
    }

    private boolean isInLoop(MacroCallItem item) {
        RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(item.getParserPath());
        if (fileDef == null) {
            return false;
        }
        RfDefElement defScope = fileDef.getScope(item.getLineInfo().realOffset - 1, true);
        if (defScope == null) {
            return false;
        }
        RfNamedElement element = defScope.getNamedElement();
        if (element == null) {
            return false;
        }
        RfNamedElement enclosingScope = element;
        while (enclosingScope instanceof RfActionBlock) {
            if (((RfActionBlock)enclosingScope).isLoop()) {
                return true;
            }
            enclosingScope = ((RfActionBlock)enclosingScope).getEnclosingScope();
        }
        return false;
    }

    protected boolean isValidConditionOfActionBlock(RfActionBlock actionBlock) {
        List<IHidOperator> hidOperators = actionBlock.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION}, true);
        if (hidOperators == null || hidOperators.isEmpty()) {
            return false;
        }
        IHidOperator iRfHidOperator = hidOperators.get(0);
        if (!(iRfHidOperator instanceof RfHidOperator)) {
            return true;
        }
        RfHidOperator op = (RfHidOperator)iRfHidOperator;
        IHidObject lhValue = op.getLHValue();
        if (!(lhValue instanceof RfHidOperator)) {
            return false;
        }
        RfHidOperator operator = (RfHidOperator)lhValue;
        if (!operator.isEqualityOrInequality()) {
            return false;
        }
        Set hids = operator.getLHHids(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
        for (IHid hid : hids) {
            IRfNamedElement element;
            if (!(hid instanceof RfHid) || !hid.isMethodCall(false) || !((element = hid.getElement()) instanceof RfFunction) || !element.getName().equals("get_report_verbosity_level")) continue;
            return true;
        }
        return false;
    }
}

