/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractLayeredSequenceCheck
extends OVMComplianceCheck {
    protected HashMap<RfFunction, IRfNamedElement> wrapedCalls = new HashMap();
    public static final String SECOND_ARGUMENT_NAME = "parent_sequence";
    public static final String FIRST_ARGUMENT_NAME = "sequencer";
    public String XVM_DECLARE_P_SEQUENCER_MACRO_NAME = "";

    protected AbstractLayeredSequenceCheck(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        this.XVM_DECLARE_P_SEQUENCER_MACRO_NAME = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_declare_p_sequencer");
        RfClass sequencerBaseClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequencer_base"), true);
        if (sequencerBaseClass == null) {
            return;
        }
        RfClass baseSequenceClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence"), true);
        if (baseSequenceClass == null) {
            return;
        }
        for (RfClass sequence : this.fOVMProject.fSequences.values()) {
            ParserPath parserPath;
            RfFileDef file = sequence.getFile();
            if (file == null || (parserPath = file.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            ArrayList<RfFunction> allFunctions = new ArrayList<RfFunction>();
            List<RfFunction> candidates = sequence.getLocalFunctions();
            if (candidates != null) {
                allFunctions.addAll(candidates);
            }
            if ((candidates = sequence.getLocalTasks()) != null) {
                allFunctions.addAll(candidates);
            }
            ArrayList<RfField> subSequences = new ArrayList<RfField>();
            List<RfField> sequenceFields = sequence.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (sequenceFields != null) {
                for (RfField field : sequenceFields) {
                    if (!this.isSubclassOf(field, baseSequenceClass)) continue;
                    subSequences.add(field);
                }
            }
            for (RfFunction function : allFunctions) {
                List<RfField> functionLocalVariables = function.getVarsWithPrefix(Integer.MAX_VALUE, "", 2);
                if (functionLocalVariables != null) {
                    for (RfField localVariable : functionLocalVariables) {
                        if (!this.isSubclassOf(localVariable, baseSequenceClass)) continue;
                        subSequences.add(localVariable);
                    }
                }
                if (subSequences.isEmpty()) continue;
                StartMethodCallHidVisitor visitor = new StartMethodCallHidVisitor(baseSequenceClass, sequencerBaseClass, parserPath, subSequences);
                function.visitHidObject(null, visitor);
            }
        }
        if (!this.wrapedCalls.isEmpty()) {
            this.fOVMProject.getRfProject().visitHidObject(null, new WrapedCallsVisitor(sequencerBaseClass));
        }
    }

    public boolean isSubclassOf(RfField eachField, RfClass baseSequenceClass) {
        RfClass subSeqType = LintUtils.getFieldFinalClassTypeOrNull(eachField);
        if (subSeqType == null) {
            return false;
        }
        return LintUtils.isSubClassOf(subSeqType, baseSequenceClass);
    }

    public abstract void visitStartMethodCall(Hid var1, RfHid var2, ParserPath var3, IRfNamedElement var4, RfClass var5);

    public void checkCorrectCall(IHidObject firstArgumentValue, RfClass baseSequencerClass, Pair wraperTask, ParserPath parserPath, RfHid rfHid, boolean task) {
        Hid functionParentHid;
        IHidObject argumentValue = firstArgumentValue;
        if (argumentValue instanceof RfHidAccessArgs) {
            Hid functionParentHid2 = ((RfHidAccessArgs)argumentValue).getParentHid();
            if (functionParentHid2 == null) {
                return;
            }
            IRfNamedElement resolvedArgumentElement = HidUtils.getResolvedElement((IHidObject)functionParentHid2);
            boolean isGetSequencerFunction = resolvedArgumentElement instanceof RfFunction && resolvedArgumentElement.getName().equals("get_sequencer");
            IRfNamedElement associatedType = ((RfHidAccessArgs)argumentValue).getAssociatedType();
            if (associatedType instanceof RfAssociatedType) {
                associatedType = LintUtils.getAssociatedFinalType((RfAssociatedType)associatedType);
            }
            if (associatedType instanceof RfClass && LintUtils.isSubClassOf((RfClass)associatedType, baseSequencerClass)) {
                if (isGetSequencerFunction) {
                    return;
                }
                if (resolvedArgumentElement instanceof RfPredefinedFunction && (resolvedArgumentElement.getName().equals("pop_back") || resolvedArgumentElement.getName().equals("pop_front"))) {
                    return;
                }
            }
            if (wraperTask != null) {
                this.wrapedCalls.put((RfFunction)wraperTask.element, wraperTask.index);
            } else {
                this.createHit(messageKind.StartCall, parserPath, rfHid, functionParentHid2, task);
            }
            return;
        }
        if (argumentValue instanceof RfHidAccess && ((RfHidAccess)argumentValue).isSelect()) {
            functionParentHid = ((RfHidAccess)argumentValue).getParentHid();
            if (functionParentHid == null) {
                return;
            }
            IRfNamedElement associatedType = ((RfHidAccess)argumentValue).getAssociatedType();
            if (associatedType instanceof RfClass && LintUtils.isSubClassOf((RfClass)associatedType, baseSequencerClass)) {
                argumentValue = functionParentHid;
            }
        }
        functionParentHid = rfHid.getParentHid();
        IRfNamedElement resolvedFirstArgument = HidUtils.getResolvedElement((IHidObject)argumentValue);
        boolean ismSequencer = resolvedFirstArgument instanceof RfField && this.isSubclassOf((RfField)resolvedFirstArgument, baseSequencerClass) && resolvedFirstArgument.getName().equals("m_sequencer");
        boolean isHierarchicalAccess = false;
        while (argumentValue instanceof RfHid) {
            Hid firstArgumentParentHid = ((RfHid)argumentValue).getParentHid();
            if (firstArgumentParentHid != null) {
                isHierarchicalAccess = true;
                resolvedFirstArgument = HidUtils.getResolvedElement((IHidObject)firstArgumentParentHid);
                argumentValue = firstArgumentParentHid;
                continue;
            }
            argumentValue = null;
        }
        if (resolvedFirstArgument == null) {
            if (!ismSequencer) {
                if (wraperTask != null) {
                    this.wrapedCalls.put((RfFunction)wraperTask.element, wraperTask.index);
                } else {
                    this.createHit(messageKind.StartCall, parserPath, rfHid, functionParentHid, task);
                }
            }
            return;
        }
        IRfDefElement fieldDeclaration = resolvedFirstArgument.getDeclaration();
        if (fieldDeclaration == null || !(fieldDeclaration instanceof RfFieldDef)) {
            return;
        }
        ReparseInfo reparseInfo = ((RfFieldDef)fieldDeclaration).getReparseInfo();
        if (reparseInfo == null) {
            if (!ismSequencer) {
                if (wraperTask != null) {
                    this.wrapedCalls.put((RfFunction)wraperTask.element, wraperTask.index);
                } else {
                    this.createHit(messageKind.StartCall, parserPath, rfHid, functionParentHid, task);
                }
            }
            return;
        }
        String macroName = reparseInfo.getLastReparseMacroName();
        if (macroName == null || !this.XVM_DECLARE_P_SEQUENCER_MACRO_NAME.equals(macroName)) {
            if (!ismSequencer) {
                if (wraperTask != null) {
                    this.wrapedCalls.put((RfFunction)wraperTask.element, wraperTask.index);
                } else {
                    this.createHit(messageKind.StartCall, parserPath, rfHid, functionParentHid, task);
                }
            }
            return;
        }
        if (!isHierarchicalAccess) {
            if (wraperTask != null) {
                this.wrapedCalls.put((RfFunction)wraperTask.element, wraperTask.index);
            } else {
                this.createHit(messageKind.StartCallShort, parserPath, rfHid, functionParentHid, task);
            }
            return;
        }
    }

    public void createHit(messageKind kind, ParserPath parserPath, RfHid rfHid, Hid functionParentHid, boolean task) {
        if (task) {
            if (kind == messageKind.StartCall) {
                this.addHit(parserPath, rfHid, "Start call wraper '" + rfHid.getName() + "' doesn't get the m_sequencer directly or via 'get_sequencer()' method call as the argument that is passed to the start call!");
                return;
            }
            if (kind == messageKind.StartCallShort) {
                this.addHit(parserPath, rfHid, "Start call wraper '" + rfHid.getName() + "' doesn't use p_sequencer to access a member for the argument that is passed to the start call!");
                return;
            }
        }
        if (kind == messageKind.StartCall) {
            this.addHit(parserPath, rfHid, "Start call on child sequence '" + functionParentHid.getName() + "' doesn't pass the m_sequencer directly or via 'get_sequencer()' method call as the first argument!");
            return;
        }
        if (kind == messageKind.StartCallShort) {
            this.addHit(parserPath, rfHid, "Start call on child sequence '" + functionParentHid.getName() + "' doesn't use p_sequencer to access a member!");
            return;
        }
    }

    protected static class Pair {
        RfNamedElement element;
        IRfNamedElement index;

        public Pair(RfNamedElement element, IRfNamedElement index) {
            this.element = element;
            this.index = index;
        }
    }

    class StartMethodCallHidVisitor
    extends RfHidVisitor {
        ParserPath methodParserPath;
        RfClass baseSequencerClass;
        RfClass baseSequenceClass;
        List<RfField> subSequences;

        public StartMethodCallHidVisitor(RfClass baseSequenceClass, RfClass baseSequencerClass, ParserPath parserPath, List<RfField> subSequences) {
            this.baseSequenceClass = baseSequenceClass;
            this.baseSequencerClass = baseSequencerClass;
            this.methodParserPath = parserPath;
            this.subSequences = subSequences;
        }

        public boolean visit(RfHid rfHid) {
            HidAccess acc = rfHid.getFirstAccess();
            if (acc == null || !(acc instanceof RfHidAccessArgs)) {
                return true;
            }
            Hid calledFunction = ((RfHidAccessArgs)acc).getParentHid();
            if (calledFunction == null) {
                return true;
            }
            IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)calledFunction);
            if (resolvedElement == null || !(resolvedElement instanceof RfFunction)) {
                return true;
            }
            if (!"start".equals(resolvedElement.getName())) {
                return true;
            }
            Hid parentHid = rfHid.getParentHid();
            if (parentHid == null) {
                return true;
            }
            IRfNamedElement parentElement = HidUtils.getResolvedElement((IHidObject)parentHid);
            if (parentElement == null || !(parentElement instanceof RfField)) {
                return true;
            }
            if (!this.subSequences.contains(parentElement)) {
                return true;
            }
            AbstractLayeredSequenceCheck.this.visitStartMethodCall(calledFunction, rfHid, this.methodParserPath, parentElement, this.baseSequencerClass);
            return true;
        }
    }

    class WrapedCallsVisitor
    implements IHidVisitor<RfHid> {
        ParserPath parserPath;
        RfClass baseSequencerClass;

        public WrapedCallsVisitor(RfClass baseSequencerClass) {
            this.baseSequencerClass = baseSequencerClass;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!AbstractLayeredSequenceCheck.this.wrapedCalls.containsKey(hidObject.getElement())) {
                return true;
            }
            IRfNamedElement index = AbstractLayeredSequenceCheck.this.wrapedCalls.get(hidObject.getElement());
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                Map argumentMap = methodCall.argumentValuesMapRaw;
                if (argumentMap == null || argumentMap.isEmpty()) {
                    return true;
                }
                IHidObject argumentValue = (IHidObject)argumentMap.get(index);
                if (argumentValue == null) {
                    return true;
                }
                AbstractLayeredSequenceCheck.this.checkCorrectCall(argumentValue, this.baseSequencerClass, null, this.parserPath, hidObject, true);
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    protected static enum messageKind {
        StartCall,
        StartCallShort;

    }
}

