/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

public abstract class AbstractMembersCheck
extends AbstractNamePatternParametersCheck {
    @CheckParameter(defaultValue="false", description="When true, the rule takes into account the registration flags to determine if the field must be in the checked method.", name="checkRegisteredFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckRegisteredFields;
    final boolean isOVMLib;
    final Set<String> fieldRegistrationMacros;
    final Set<String> registrationFlagsNotChecked;

    public AbstractMembersCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        this.fieldRegistrationMacros = this.isOVMLib ? new HashSet<String>(Arrays.asList(XVMMacros.OVM_FIELD_MACROS)) : new HashSet<String>(Arrays.asList(XVMMacros.UVM_FIELD_MACROS));
        this.registrationFlagsNotChecked = this.isOVMLib ? new HashSet<String>(Arrays.asList("OVM_DEFAULT", "OVM_FLAGS_ON", "OVM_ALL_ON")) : new HashSet<String>(Arrays.asList("UVM_DEFAULT", "UVM_FLAGS_ON", "UVM_ALL_ON"));
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        if (!this.pCheckRegisteredFields) {
            return;
        }
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_FIELD_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_FIELD_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    protected void checkMembersInDoCopy(RfFunction method, List<RfField> fieldsToCheck, List<RfField> fieldsToFail, boolean checkRegisteredFields) {
        this.notifyCheckAlive();
        Set<RfField> unreferredFieldsToCheck = new HashSet<RfField>();
        HashSet<RfField> unreferredFieldsToFail = new HashSet<RfField>();
        for (RfField field : fieldsToCheck) {
            if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || field.isStorageStatic()) continue;
            unreferredFieldsToCheck.add(field);
        }
        if (checkRegisteredFields) {
            for (RfField field : fieldsToFail) {
                if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || field.isStorageStatic()) continue;
                unreferredFieldsToFail.add(field);
            }
        }
        CopyHidVisitor copyVisitor = new CopyHidVisitor(unreferredFieldsToCheck, unreferredFieldsToFail, checkRegisteredFields);
        copyVisitor.setParserPath(method.getMacroParserPath());
        method.visitHidObject(null, copyVisitor);
        unreferredFieldsToCheck = copyVisitor.getUnrefferedFieldsToCheck();
        for (RfField field : unreferredFieldsToCheck) {
            this.addHitOnFunctionDefinition(method, "do_copy method doesn't include: '" + field.getName() + "'!");
        }
    }

    protected void checkMembersInDoPrint(RfFunction method, List<RfField> fieldsToCheck, List<RfField> fieldsToFail, boolean checkRegisteredFields) {
        this.notifyCheckAlive();
        Set<RfField> unreferredFieldsToCheck = new HashSet<RfField>();
        HashSet<RfField> unreferredFieldsToFail = new HashSet<RfField>();
        for (RfField field : fieldsToCheck) {
            if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || field.isStorageStatic()) continue;
            unreferredFieldsToCheck.add(field);
        }
        if (checkRegisteredFields) {
            for (RfField field : fieldsToFail) {
                if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || field.isStorageStatic()) continue;
                unreferredFieldsToFail.add(field);
            }
        }
        String libPrinterName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_printer");
        List<RfField> printerCandidates = method.getArgumentsWithPrefix("", 2);
        if (printerCandidates == null || printerCandidates.isEmpty()) {
            this.addHitOnFunctionDefinition(method, "do_print method doesn't have a " + libPrinterName + " argument");
            return;
        }
        RfField printer = printerCandidates.get(0);
        if (printer.getDataType() != null && !libPrinterName.equals(printer.getDataType().getType())) {
            this.addHitOnFunctionDefinition(method, "do_print method's first argument's type is not " + libPrinterName);
            return;
        }
        LocalHidVisitor printVisitor = new LocalHidVisitor("print_", printer, unreferredFieldsToCheck, unreferredFieldsToFail, checkRegisteredFields);
        method.visitHidObject(null, printVisitor);
        unreferredFieldsToCheck = printVisitor.getUnrefferedFieldsToCheck();
        for (RfField field : unreferredFieldsToCheck) {
            this.addHitOnFunctionDefinition(method, "do_print method doesn't include: '" + field.getName() + "'!");
        }
    }

    protected void checkMembersInDoCompare(RfFunction method, List<RfField> fieldsToCheck, List<RfField> fieldsToFail, boolean checkRegisteredFields) {
        this.notifyCheckAlive();
        Set<RfField> unreferredFieldsToCheck = new HashSet<RfField>();
        HashSet<RfField> unreferredFieldsToFail = new HashSet<RfField>();
        for (RfField field : fieldsToCheck) {
            if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || field.isStorageStatic()) continue;
            unreferredFieldsToCheck.add(field);
        }
        if (checkRegisteredFields) {
            for (RfField field : fieldsToFail) {
                if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field) || field.isStorageStatic()) continue;
                unreferredFieldsToFail.add(field);
            }
        }
        List<RfField> comparerCandidates = method.getArgumentsWithPrefix("", 2);
        String libComparerName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_comparer");
        if (comparerCandidates == null || comparerCandidates.isEmpty()) {
            this.addHitOnFunctionDefinition(method, "do_compare method doesn't have a " + libComparerName + " argument");
            return;
        }
        RfField comparer = null;
        for (RfField argument : comparerCandidates) {
            if (argument.getDataType() == null || !libComparerName.equals(argument.getDataType().getType())) continue;
            comparer = argument;
        }
        if (comparer == null) {
            this.addHitOnFunctionDefinition(method, "do_compare method doesn't have a " + libComparerName + " argument");
            return;
        }
        LocalHidVisitor compareVisitor = new LocalHidVisitor("compare_", comparer, unreferredFieldsToCheck, unreferredFieldsToFail, checkRegisteredFields);
        method.visitHidObject(null, compareVisitor);
        unreferredFieldsToCheck = compareVisitor.getUnrefferedFieldsToCheck();
        for (RfField field : unreferredFieldsToCheck) {
            this.addHitOnFunctionDefinition(method, "do_compare method doesn't include: '" + field.getName() + "'!");
        }
    }

    protected FieldsInfo getFieldsInfo(RfClass seqItem, List<RfField> fields, String methodName) {
        String specificRegistrationFlag = "";
        String registrationFlagToFail = "";
        methodName = methodName.substring(3);
        if (this.isOVMLib) {
            specificRegistrationFlag = "OVM_" + methodName.toUpperCase();
            registrationFlagToFail = "OVM_NO" + methodName.toUpperCase();
        } else {
            specificRegistrationFlag = "UVM_" + methodName.toUpperCase();
            registrationFlagToFail = "UVM_NO" + methodName.toUpperCase();
        }
        HashSet<String> fieldsNotCheckedSet = new HashSet<String>();
        HashSet<String> fieldsToFailSet = new HashSet<String>();
        ArrayList<RfField> fieldsToCheck = new ArrayList<RfField>();
        ArrayList<RfField> fieldsToFail = new ArrayList<RfField>();
        if (!this.pCheckRegisteredFields) {
            fieldsToCheck.addAll(fields);
        } else {
            MacroCallInfo macroInfo = seqItem.getMacroCallInfo();
            if (macroInfo == null) {
                return null;
            }
            List<MacroCallItem> allMacrosUsed = macroInfo.getItems();
            if (allMacrosUsed == null) {
                return null;
            }
            for (MacroCallItem macroCall : allMacrosUsed) {
                if (!this.fieldRegistrationMacros.contains(macroCall.getName())) {
                    return null;
                }
                String[] parameters = macroCall.getMacroParameters();
                if (parameters.length == 0) {
                    return null;
                }
                String registeredField = "";
                String registrationFlags = "";
                if (macroCall.getName().contains("enum") || macroCall.getName().contains("enumkey")) {
                    registeredField = macroCall.getMacroParameters()[1];
                    registrationFlags = macroCall.getMacroParameters()[2];
                } else {
                    registeredField = macroCall.getMacroParameters()[0];
                    registrationFlags = macroCall.getMacroParameters()[1];
                }
                for (String flag : this.registrationFlagsNotChecked) {
                    if (!registrationFlags.contains(flag) && !registrationFlags.contains(specificRegistrationFlag)) continue;
                    fieldsNotCheckedSet.add(registeredField);
                }
                if (!registrationFlags.contains(registrationFlagToFail)) continue;
                fieldsToFailSet.add(registeredField);
            }
            for (RfField field : fields) {
                if (fieldsToFailSet.contains(field.getName())) {
                    fieldsToFail.add(field);
                    continue;
                }
                if (fieldsNotCheckedSet.contains(field.getName())) continue;
                fieldsToCheck.add(field);
            }
        }
        return new FieldsInfo(fieldsToCheck, fieldsToFail);
    }

    private class CopyHidVisitor
    implements IHidVisitor<IHidObject> {
        Set<RfField> unrefferedFieldsToCheck;
        Set<RfField> unrefferedFieldsToFail;
        boolean checkRegisteredFields;
        ParserPath parserPath;

        public CopyHidVisitor(Set<RfField> unrefferedFieldsToCheck, Set<RfField> unrefferedFieldsToFail, boolean checkRegisteredFields) {
            this.unrefferedFieldsToCheck = unrefferedFieldsToCheck;
            this.unrefferedFieldsToFail = unrefferedFieldsToFail;
            this.checkRegisteredFields = checkRegisteredFields;
        }

        public boolean visit(IHidObject object) {
            if (object instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)object;
                this.checkAssignment(operator);
            } else if (object instanceof RfHid) {
                RfHid rfHid = (RfHid)object;
                if (!rfHid.isMethodCall(false)) {
                    return true;
                }
                if (!rfHid.getName().equals("$cast") && !rfHid.getName().equals("copy")) {
                    return true;
                }
                if (rfHid.getName().equals("$cast")) {
                    this.checkCast(rfHid);
                } else {
                    this.checkCopy(rfHid);
                }
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        private void checkAssignment(RfHidOperator operator) {
            if (!operator.isAssignment()) {
                return;
            }
            IHidObject lhObject = operator.getLHValue();
            if (operator.getRHValues() == null || operator.getRHValues().size() != 1) {
                return;
            }
            IHidObject rhObject = (IHidObject)operator.getRHValues().get(0);
            if (lhObject instanceof RfHidAccess && ((RfHidAccess)lhObject).getParentHid() != null) {
                lhObject = ((RfHidAccess)lhObject).getParentHid();
            }
            if (!(lhObject instanceof RfHid)) {
                return;
            }
            RfHid lhHid = (RfHid)lhObject;
            if (lhHid.getParentAccess() != null && !lhHid.getParentHid().getName().equals("this")) {
                return;
            }
            if (!(lhHid.getElement() instanceof RfNamedElement)) {
                return;
            }
            RfNamedElement hidElement = (RfNamedElement)lhHid.getElement();
            if (!(!(hidElement instanceof RfField) || !(((RfField)hidElement).getAssociatedType() instanceof RfClass) || rhObject instanceof RfHid && ((RfHid)rhObject).getName().equals("clone") || rhObject instanceof RfHidAccessArgs && ((RfHidAccessArgs)rhObject).getParentHid() != null && ((RfHidAccessArgs)rhObject).getParentHid().getName() != null && ((RfHidAccessArgs)rhObject).getParentHid().getName().equals("clone"))) {
                if (lhHid.getElement() instanceof RfField && this.unrefferedFieldsToCheck.contains(lhHid.getElement())) {
                    AbstractMembersCheck.this.addHit(this.parserPath, lhHid, "'" + lhHid.getName() + "' is a class object, it should be copied by $cast, .copy() or .clone()!");
                }
                return;
            }
            if (!(hidElement instanceof RfField)) {
                return;
            }
            if (this.checkRegisteredFields && this.unrefferedFieldsToFail.contains(hidElement)) {
                AbstractMembersCheck.this.addHit(this.parserPath, lhHid, "'" + lhHid.getName() + "' should not be copied according to its registration flags!");
            } else {
                this.unrefferedFieldsToCheck.remove(hidElement);
            }
        }

        private void checkCast(RfHid rfHid) {
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return;
            }
            for (MethodCall methodCall : methodCalls) {
                RfHid firstArgumentHid;
                if (methodCall.argumentValuesMapRaw == null) continue;
                Hid firstArgumentValue = null;
                IHidObject secondArgumentValue = null;
                for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject argumentValue = (IHidObject)argument.getValue();
                    if (argumentValue == null) continue;
                    if (((IRfFieldElement)argument.getKey()).getName().equals("dest_var")) {
                        firstArgumentValue = argumentValue;
                        continue;
                    }
                    if (!((IRfFieldElement)argument.getKey()).getName().equals("source_exp")) continue;
                    secondArgumentValue = argumentValue;
                }
                if (firstArgumentValue instanceof RfHidAccess && ((RfHidAccess)firstArgumentValue).getParentHid() != null) {
                    firstArgumentValue = ((RfHidAccess)firstArgumentValue).getParentHid();
                }
                if (!(firstArgumentValue instanceof RfHid) || (firstArgumentHid = (RfHid)firstArgumentValue).getParentAccess() != null && firstArgumentHid.getParentHid().getName() != null && !firstArgumentHid.getParentHid().getName().equals("this") || !(firstArgumentHid.getElement() instanceof RfField) || secondArgumentValue == null) continue;
                RfField hidElement = (RfField)firstArgumentHid.getElement();
                if (this.checkRegisteredFields && this.unrefferedFieldsToFail.contains(hidElement)) {
                    AbstractMembersCheck.this.addHit(this.parserPath, firstArgumentHid, "'" + firstArgumentHid.getName() + "' should not be copied according to its registration flags!");
                    continue;
                }
                this.unrefferedFieldsToCheck.remove(hidElement);
            }
        }

        private void checkCopy(RfHid rfHid) {
            if (rfHid.getParentAccess() == null) {
                return;
            }
            Hid parentHid = null;
            parentHid = rfHid.getParentAccess() instanceof RfHidAccess && ((RfHidAccess)rfHid.getParentAccess()).getParentHid() != null ? rfHid.getParentAccess().getParentHid() : rfHid.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return;
            }
            RfHid fieldHid = (RfHid)parentHid;
            if (fieldHid.getParentAccess() != null && fieldHid.getParentHid().getName() != null && !fieldHid.getParentHid().getName().equals("this")) {
                return;
            }
            if (!(fieldHid.getElement() instanceof RfField)) {
                return;
            }
            IRfNamedElement assocType = ((RfField)fieldHid.getElement()).getAssociatedType();
            if (assocType instanceof RfListType || assocType instanceof RfTypeAlias) {
                assocType = LintUtils.getAssociatedFinalType((IRfAssociatedTypeElement)assocType);
            }
            if (!(assocType instanceof RfClass)) {
                return;
            }
            RfField hidElement = (RfField)fieldHid.getElement();
            if (this.checkRegisteredFields && this.unrefferedFieldsToFail.contains(hidElement)) {
                AbstractMembersCheck.this.addHit(this.parserPath, fieldHid, "'" + fieldHid.getName() + "' should not be copied according to its registration flags!");
            } else {
                this.unrefferedFieldsToCheck.remove(hidElement);
            }
        }

        public Set<RfField> getUnrefferedFieldsToCheck() {
            return this.unrefferedFieldsToCheck;
        }
    }

    static class FieldsInfo {
        List<RfField> fieldsToCheck;
        List<RfField> fieldsToFail;

        public FieldsInfo(List<RfField> fieldsToCheck, List<RfField> fieldsToFail) {
            this.fieldsToCheck = fieldsToCheck;
            this.fieldsToFail = fieldsToFail;
        }

        public List<RfField> getFieldsToCheck() {
            return this.fieldsToCheck;
        }

        public List<RfField> getFieldsToFail() {
            return this.fieldsToFail;
        }
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        String prefix;
        RfField uvmObject;
        Set<RfField> unrefferedFieldsToCheck;
        Set<RfField> unrefferedFieldsToFail;
        boolean checkRegisteredFields;

        public LocalHidVisitor(String prefix, RfField uvmObject, Set<RfField> unrefferedFieldsToCheck, Set<RfField> unrefferedFieldsToFail, boolean checkRegisteredFields) {
            this.prefix = prefix;
            this.uvmObject = uvmObject;
            this.unrefferedFieldsToCheck = unrefferedFieldsToCheck;
            this.unrefferedFieldsToFail = unrefferedFieldsToFail;
            this.checkRegisteredFields = checkRegisteredFields;
        }

        public boolean visit(RfHid rfHid) {
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (!rfHid.getName().startsWith(this.prefix)) {
                return true;
            }
            HidAccess parentAccess = rfHid.getParentAccess();
            if (parentAccess == null || parentAccess.getAccessKind() != 0) {
                return true;
            }
            if (!parentAccess.getParentHid().getElement().equals(this.uvmObject)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMap == null) continue;
                for (Map.Entry argument : methodCall.argumentValuesMap.entrySet()) {
                    Set argumentValues = (Set)argument.getValue();
                    if (argumentValues == null || argumentValues.isEmpty() || this.prefix.equals("print_") && !((IRfFieldElement)argument.getKey()).getName().equals("value") || this.prefix.equals("compare_") && !((IRfFieldElement)argument.getKey()).getName().equals("lhs") && !((IRfFieldElement)argument.getKey()).getName().equals("rhs")) continue;
                    for (IHid argumentValue : argumentValues) {
                        RfHid argumentValueHid;
                        if (!(argumentValue instanceof RfHid) || (argumentValueHid = (RfHid)argumentValue).getParentAccess() != null && argumentValueHid.getParentHid().getName() != null && !argumentValueHid.getParentHid().getName().equals("this") || !(argumentValueHid.getElement() instanceof RfField)) continue;
                        RfField hidElement = (RfField)argumentValueHid.getElement();
                        if (this.checkRegisteredFields && this.unrefferedFieldsToFail.contains(hidElement)) {
                            String errorMessage = this.prefix.equals("print_") ? "printed" : "compared";
                            AbstractMembersCheck.this.addHit(this.parserPath, argumentValueHid, "'" + argumentValueHid.getName() + "' should not be " + errorMessage + " according to its registration flags!");
                            continue;
                        }
                        this.unrefferedFieldsToCheck.remove(hidElement);
                    }
                }
            }
            return true;
        }

        public Set<RfField> getUnrefferedFieldsToCheck() {
            return this.unrefferedFieldsToCheck;
        }
    }
}

