/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractNameCheck
extends OVMComplianceCheck {
    public static final String SUFFIX_PARAMETER = "suffix";
    protected String suffixesMessage;
    @CheckParameter(defaultValue="", description="Comma separated list of allowed suffixes.", name="suffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSuffixValues;

    protected AbstractNameCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected abstract String getHitMessage(RfNamedElement var1, String var2);

    protected abstract Map<String, RfClass> getComponents();

    @Override
    public void configure() {
        super.configure();
        this.checkForEmptyParameters();
    }

    protected void checkForEmptyParameters() {
        if (this.pSuffixValues == null || this.pSuffixValues.isEmpty()) {
            this.signalParamError("Parameter \"suffix\" must have at least one value!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.suffixesMessage = DVTStringUtil.join(this.pSuffixValues, (String)", ");
        this.checkComponentNames();
    }

    protected void checkComponentNames() {
        Map<String, RfClass> components = this.getComponents();
        if (components == null || components.isEmpty()) {
            return;
        }
        for (RfClass component : components.values()) {
            this.notifyCheckAlive();
            RfDefElement defElem = component.getDeclaration();
            if (defElem != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElem.getParserPath(), this)) continue;
            this.checkValidName(component);
        }
    }

    protected void checkValidName(RfNamedElement component) {
        this.checkValidName(component, this.pSuffixValues);
    }

    protected void checkValidName(RfNamedElement component, Set<String> suffixes) {
        for (String suffix : suffixes) {
            if (!component.getName().endsWith(suffix)) continue;
            return;
        }
        this.addHit(component, this.getHitMessage(component, this.suffixesMessage), new VerissimoAutofixAdditionalInfo(component));
    }
}

