/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;

public abstract class AbstractOverrideMethodCheck
extends OVMComplianceCheck {
    protected static Function<RfHidAccessArgs, List<IHidObject>> getFirstArg = new Function<RfHidAccessArgs, List<IHidObject>>(){

        @Override
        public List<IHidObject> apply(RfHidAccessArgs hidAccess) {
            Hid parent;
            ArrayList<IHidObject> result = new ArrayList<IHidObject>();
            Hid hid = parent = hidAccess.getParentHid() != null ? hidAccess.getParentHid().getParentHid() : null;
            if (parent != null && "type_id".equals(parent.getName())) {
                result.add((IHidObject)parent.getParentHid());
                result.add(hidAccess.getArgumentValues().get(0));
            }
            return result;
        }
    };
    protected static Function<RfHidAccessArgs, List<IHidObject>> getFirstAndSecondArg = new Function<RfHidAccessArgs, List<IHidObject>>(){

        @Override
        public List<IHidObject> apply(RfHidAccessArgs hidAccess) {
            ArrayList<IHidObject> result = new ArrayList<IHidObject>();
            result.add(hidAccess.getArgumentValues().get(0));
            result.add(hidAccess.getArgumentValues().get(1));
            return result;
        }
    };
    protected static Function<RfHidAccessArgs, List<IHidObject>> getSecondAndThirdArg = new Function<RfHidAccessArgs, List<IHidObject>>(){

        @Override
        public List<IHidObject> apply(RfHidAccessArgs hidAccess) {
            ArrayList<IHidObject> result = new ArrayList<IHidObject>();
            result.add(hidAccess.getArgumentValues().get(1));
            result.add(hidAccess.getArgumentValues().get(2));
            return result;
        }
    };

    public AbstractOverrideMethodCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected RfPackage getXVMPackage() {
        RfPackage xvmPackage = null;
        String xvmPackageName = String.valueOf(this.fOVMProject.getLibraryKindPrefixes()[0]) + "_pkg";
        List<RfPackage> allPackages = this.fOVMProject.getRfProject().getAllPackages(true);
        for (RfPackage pkg : allPackages) {
            if (!xvmPackageName.equals(pkg.getName())) continue;
            xvmPackage = pkg;
            break;
        }
        return xvmPackage;
    }

    protected RfClass getXVMClass(RfPackage xvmPackage, String name) {
        String xvmClassName = String.valueOf(this.fOVMProject.getLibraryKindPrefixes()[0]) + name;
        RfClass xvmClass = xvmPackage.getClassWithPrefix(xvmClassName, 1, 1);
        return xvmClass;
    }

    protected RfFunction getXVMFunction(RfClass xvmClass, String name) {
        RfFunction xvmMethod = xvmClass.getFunctionWithPrefix(name, 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
        return xvmMethod;
    }

    protected Map<RfFunction, Function<RfHidAccessArgs, List<IHidObject>>> getOverrideMethodsMap() {
        HashMap<RfFunction, Function<RfHidAccessArgs, List<IHidObject>>> overrideMethodsMap = new HashMap<RfFunction, Function<RfHidAccessArgs, List<IHidObject>>>();
        RfPackage xvmPackage = this.getXVMPackage();
        if (xvmPackage == null) {
            return null;
        }
        RfFunction xvmMethod = null;
        RfClass xvmClass = null;
        xvmClass = this.getXVMClass(xvmPackage, "_object_registry");
        if (xvmClass == null) {
            return null;
        }
        xvmMethod = this.getXVMFunction(xvmClass, "set_type_override");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getFirstArg);
        xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getFirstArg);
        xvmClass = this.getXVMClass(xvmPackage, "_factory");
        if (xvmClass == null) {
            return null;
        }
        xvmMethod = this.getXVMFunction(xvmClass, "set_type_override_by_type");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getFirstAndSecondArg);
        xvmMethod = this.getXVMFunction(xvmClass, "set_type_override_by_name");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getFirstAndSecondArg);
        xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override_by_type");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getFirstAndSecondArg);
        xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override_by_name");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getFirstAndSecondArg);
        xvmClass = this.getXVMClass(xvmPackage, "_component");
        if (xvmClass == null) {
            return null;
        }
        xvmMethod = this.getXVMFunction(xvmClass, "set_type_override_by_type");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getFirstAndSecondArg);
        xvmMethod = this.getXVMFunction(xvmClass, "set_type_override");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getFirstAndSecondArg);
        xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override_by_type");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getSecondAndThirdArg);
        xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethodsMap.put(xvmMethod, getSecondAndThirdArg);
        return overrideMethodsMap;
    }
}

