/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

public abstract class AbstractReportMacroIDCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="`xvm_info, `xvm_warning, `xvm_error, `xvm_fatal", description="Comma separated list of reporting macros to be checked.", name="reportingMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pReportingMacros;
    protected boolean missingIDHit = true;
    private HashSet<String> reportMethods;

    protected AbstractReportMacroIDCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        this.reportMethods = new HashSet();
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.reportMethods.add("ovm_pkg::ovm_report_object.ovm_report_info");
            this.reportMethods.add("ovm_pkg::ovm_report_object.ovm_report_warning");
            this.reportMethods.add("ovm_pkg::ovm_report_object.ovm_report_error");
            this.reportMethods.add("ovm_pkg::ovm_report_object.ovm_report_fatal");
            this.reportMethods.add("ovm_pkg::ovm_report_info");
            this.reportMethods.add("ovm_pkg::ovm_report_warning");
            this.reportMethods.add("ovm_pkg::ovm_report_error");
            this.reportMethods.add("ovm_pkg::ovm_report_fatal");
        } else if (this.fOVMProject.getLibraryKind() == 2) {
            this.reportMethods.add("uvm_pkg::uvm_report_info");
            this.reportMethods.add("uvm_pkg::uvm_report_warning");
            this.reportMethods.add("uvm_pkg::uvm_report_error");
            this.reportMethods.add("uvm_pkg::uvm_report_fatal");
            this.reportMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_info");
            this.reportMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_warning");
            this.reportMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_error");
            this.reportMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_fatal");
            this.reportMethods.add("uvm_pkg::uvm_report_object.uvm_report_info");
            this.reportMethods.add("uvm_pkg::uvm_report_object.uvm_report_warning");
            this.reportMethods.add("uvm_pkg::uvm_report_object.uvm_report_error");
            this.reportMethods.add("uvm_pkg::uvm_report_object.uvm_report_fatal");
            this.reportMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_info");
            this.reportMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_warning");
            this.reportMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_error");
            this.reportMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_fatal");
            this.reportMethods.add("uvm_pkg::uvm_report_message.set_report_message");
        }
    }

    @Override
    public void performCheckImpl() {
        MethodCallVisitor visitor = new MethodCallVisitor();
        RfProject rfProject = this.fOVMProject.getRfProject();
        try {
            rfProject.visitHidObject(null, visitor);
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected String unquote(String id) {
        if (!LintUtils.isStringLiteral(id)) {
            return null;
        }
        return id.substring(1, id.length() - 1);
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected abstract void checkFirstID(IHidObject var1, HidOccurrence var2, String var3, RfNamedElement var4);

    private class MethodCallVisitor
    extends RfHidVisitor {
        RfNamedElement scope;

        public void setScope(IRfNamedElement scope) {
            if (scope instanceof RfNamedElement) {
                this.scope = (RfNamedElement)scope;
            }
        }

        public boolean visit(RfHid rfHid) {
            String fileName = LintUtils.getFileShortName(this.parserPath.path);
            if (AbstractReportMacroIDCheck.this.fOVMProject.isOVMFile(fileName)) {
                return true;
            }
            if (AbstractReportMacroIDCheck.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            IRfNamedElement element = rfHid.getElement();
            if (element == null || !(element instanceof RfFunction)) {
                return true;
            }
            AbstractReportMacroIDCheck.this.notifyCheckAlive();
            if (!AbstractReportMacroIDCheck.this.reportMethods.contains(LintUtils.getHidFullName((IHid)rfHid))) {
                return true;
            }
            IReparseInfo reparseInfo = rfHid.getReparseInfo();
            if (!(reparseInfo instanceof ReparseInfo)) {
                return true;
            }
            ReparseInfo.ReparseElement reparseElement = ((ReparseInfo)reparseInfo).getReparseStack()[0];
            String macroName = reparseElement.getReparseMacroName();
            if (!AbstractReportMacroIDCheck.this.pReportingMacros.contains("`" + macroName)) {
                return true;
            }
            HidOccurrence occurence = rfHid.getOccurrence();
            if (occurence == null) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    if (!((IRfFieldElement)entry.getKey()).getName().equals("id") || entry.getValue() == null) continue;
                    AbstractReportMacroIDCheck.this.checkFirstID((IHidObject)entry.getValue(), occurence, macroName, this.scope);
                    return true;
                }
            }
            AbstractReportMacroIDCheck.this.addHit(this.parserPath, occurence.getLine(), "No ID specified for " + macroName + "!", null);
            return true;
        }
    }
}

