/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;

public abstract class AbstractSequenceItemsMethodExistenceCheck
extends OVMComplianceCheck {
    public AbstractSequenceItemsMethodExistenceCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected void checkSequenceItemsMethodExistence(String methodName, boolean includeTopItems) {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        for (RfClass seqItem : this.fOVMProject.fSequenceItems.values()) {
            List<RfFunction> candidates;
            this.notifyCheckAlive();
            boolean checkAddedMembers = true;
            RfClass parent = seqItem.getParent();
            if (parent == null || !this.fOVMProject.fSequenceItems.containsKey(parent.getFullName())) {
                if (!includeTopItems) continue;
                checkAddedMembers = false;
            }
            if (checkAddedMembers) {
                List<RfField> fields = seqItem.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                int nonOVM = 0;
                if (fields != null) {
                    for (RfField field : fields) {
                        if (XVMLintUtils.isInOVMMacroCall(this.fOVMProject, field)) continue;
                        ++nonOVM;
                    }
                }
                if (nonOVM == 0) {
                    this.addPassedHit(seqItem, "Sequence item '" + seqItem.getName() + "' does not have additional member variables");
                    continue;
                }
            }
            if ((candidates = seqItem.getFunctionsWithPrefix(methodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || candidates.isEmpty()) {
                this.addHit(seqItem, "Sequence item '" + seqItem.getName() + "' does not implement " + methodName);
                continue;
            }
            this.addPassedHit(candidates.get(0), "Sequence item '" + seqItem.getName() + "' implements " + methodName);
        }
    }
}

