/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractSetConfigurationFunctionCheck
extends OVMComplianceCheck {
    protected static final List<String> SET_FUNCTION_WRAPPERS = Arrays.asList("set_config_int", "set_config_string", "set_config_object");
    protected static final List<String> GET_FUNCTION_WRAPPERS = Arrays.asList("get_config_int", "get_config_string", "get_config_object");
    protected boolean checkSetConfig = false;
    protected boolean checkGetConfig = false;

    public AbstractSetConfigurationFunctionCheck(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    protected abstract void checkMethodCalls(List<MethodCall> var1, RfHid var2, ParserPath var3);

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        SetConfigurationFunctionVisitor functionVisitor = new SetConfigurationFunctionVisitor();
        rfProject.visitHidObject(rfProject, functionVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected class SetConfigurationFunctionVisitor
    extends RfHidVisitor {
        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (AbstractSetConfigurationFunctionCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (hidNamedElement.isPredefined()) {
                return true;
            }
            if (!(this.holder instanceof HidHolder)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope == null) {
                return true;
            }
            if (!(holderScope instanceof RfNamedElement)) {
                return true;
            }
            RfPackage enclosingPackage = (RfPackage)holderScope.getEnclosingScope(RfPackage.class);
            if (enclosingPackage != null && AbstractSetConfigurationFunctionCheck.this.fOVMProject.isOVMElement(enclosingPackage)) {
                return true;
            }
            AbstractSetConfigurationFunctionCheck.this.notifyCheckAlive();
            if (!LintUtils.isSetOrGetConfigurationFunction(hid, SET_FUNCTION_WRAPPERS, GET_FUNCTION_WRAPPERS, AbstractSetConfigurationFunctionCheck.this.checkSetConfig, AbstractSetConfigurationFunctionCheck.this.checkGetConfig)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            AbstractSetConfigurationFunctionCheck.this.checkMethodCalls(methodCalls, hid, this.parserPath);
            return true;
        }
    }
}

