/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

public abstract class AbstractSuperMethodCallCheck
extends OVMComplianceCheck {
    public AbstractSuperMethodCallCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected void checkSuperMethodCall(String methodName) {
        String ovm_uvm_object = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
        NullProtectedList<RfNamedElement> allFunctions = this.fOVMProject.getAllFunctions();
        for (RfNamedElement function : allFunctions) {
            RfNamedElement container;
            if (!methodName.equals(function.getName())) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(function.getFile()) || (container = function.getClosestTypeContainer()) == null || !(container instanceof RfClass) || !((RfClass)container).isSubClass(ovm_uvm_object, true)) continue;
            List<RfFunctionCall> superCalls = function.getFunctionCallsWithPrefix("super." + methodName, 1);
            if (superCalls == null || superCalls.isEmpty()) {
                this.addHitOnFunctionDefinition((RfFunction)function, String.valueOf(methodName) + " method does not call super." + methodName + "()");
                continue;
            }
            this.addPassedHit(superCalls.get(0), String.valueOf(methodName) + " method calls super." + methodName + "()");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

