/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsMacroCheck;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

public abstract class AbstractUtilsBeginEndMacroCheck
extends AbstractUtilsMacroCheck {
    @CheckParameter(defaultValue="false", description="Allows the use of `xvm_component_utils_begin(my_component) or `xvm_component_param_utils_begin(my_component#(my_params)) for items with registered fields.", name="allowBeginEndMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowBeginEndMacrosValue;

    public AbstractUtilsBeginEndMacroCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_CLASS_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_CLASS_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_ABSTRACT_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    protected void checkMacros(Map<String, RfClass> classes, Set<String> requestedNoParamMacro, Set<String> requestedParamMacro, Set<String> beginNoParamMacro, String endNoParamMacro, Set<String> beginParamMacro, boolean allowTypedefs, boolean allowNonParamMacroForParamClasses) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        for (RfClass classs : classes.values()) {
            this.notifyCheckAlive();
            boolean hasParams = false;
            HashSet<String> requestedMacros = new HashSet<String>();
            requestedMacros.addAll(requestedNoParamMacro);
            HashSet<String> beginMacros = new HashSet<String>();
            beginMacros.addAll(beginNoParamMacro);
            String endMacro = endNoParamMacro;
            if (classs.hasPortListParameters()) {
                if (!allowNonParamMacroForParamClasses) {
                    beginMacros.clear();
                    requestedMacros.clear();
                }
                beginMacros.addAll(beginParamMacro);
                requestedMacros.addAll(requestedParamMacro);
                hasParams = true;
            }
            MacroCallInfo macroInfo = classs.getMacroCallInfo();
            boolean anyHit = false;
            if (macroInfo != null) {
                List<MacroCallItem> endItems;
                if (this.pAllowBeginEndMacrosValue && !anyHit && !beginMacros.isEmpty() && endMacro != null && (endItems = macroInfo.getItems(endMacro)) != null && !endItems.isEmpty()) {
                    anyHit = this.checkUtilsMacroInClass(classs, hasParams, beginMacros, true, allowTypedefs, allowNonParamMacroForParamClasses);
                }
                if (!anyHit) {
                    anyHit = this.checkUtilsMacroInClass(classs, hasParams, requestedMacros, false, allowTypedefs, allowNonParamMacroForParamClasses);
                }
            }
            Set nonAbstractUtilsMacros = requestedMacros.stream().filter(x -> !x.contains("abstract")).collect(Collectors.toSet());
            Set nonAbstractBeginMacros = beginMacros.stream().filter(x -> !x.contains("abstract")).collect(Collectors.toSet());
            if (anyHit || classs.hasVirtualQualifier()) continue;
            if (beginMacros.isEmpty() || endMacro == null || !this.pAllowBeginEndMacrosValue) {
                this.addHit(classs, "Macro " + DVTStringUtil.join(nonAbstractUtilsMacros, (String)",") + " was not found");
                continue;
            }
            this.addHit(classs, "Macros " + DVTStringUtil.join(nonAbstractUtilsMacros, (String)",") + " or " + DVTStringUtil.join(nonAbstractBeginMacros, (String)",") + " and " + endMacro + " were not found");
        }
    }
}

