/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

public abstract class AbstractUtilsFactoryRegistrationMacrosCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of packages to be skipped.", name="skipClassesInPackages", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipClassesInPackages;
    private final HashSet<String> relevantMacros = new HashSet();

    public AbstractUtilsFactoryRegistrationMacrosCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.relevantMacros.addAll(Arrays.asList("`ovm_sequence_utils", "`ovm_sequence_utils_begin", "`ovm_component_utils", "`ovm_component_param_utils", "`ovm_component_utils_begin", "`ovm_component_param_utils_begin", "`ovm_object_utils", "`ovm_object_param_utils", "`ovm_object_utils_begin", "`ovm_object_param_utils_begin", "`ovm_sequencer_utils", "`ovm_sequencer_param_utils", "`ovm_sequencer_utils_begin", "`ovm_sequencer_param_utils_begin"));
        } else {
            this.relevantMacros.addAll(Arrays.asList("`uvm_sequence_utils", "`uvm_sequence_utils_begin", "`uvm_component_utils", "`uvm_component_param_utils", "`uvm_component_utils_begin", "`uvm_component_param_utils_begin", "`uvm_object_utils", "`uvm_object_param_utils", "`uvm_object_utils_begin", "`uvm_object_param_utils_begin", "`uvm_sequencer_utils", "`uvm_sequencer_param_utils", "`uvm_sequencer_utils_begin", "`uvm_sequencer_param_utils_begin"));
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("class", this.relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement element : this.fOVMProject.getAllNonXVMClasses()) {
            MacroCallInfo macroCallInfo;
            List<MacroCallItem> macroCallItems;
            RfClass currentClass;
            RfPackage enclosingPackage;
            this.notifyCheckAlive();
            if (element == null || !(element instanceof RfClass) || (enclosingPackage = (currentClass = (RfClass)element).getEnclosingPackage()) == null || !this.pSkipClassesInPackages.isEmpty() && this.pSkipClassesInPackages.contains(enclosingPackage.getName()) || (macroCallItems = LintUtils.getMacroCallsInSet(macroCallInfo = currentClass.getMacroCallInfo(), this.relevantMacros, false, false)) == null || macroCallItems.isEmpty()) continue;
            for (MacroCallItem macroCall : macroCallItems) {
                String firstParam = macroCall.getMacroParameters()[0];
                if (currentClass.hasPortListParameters() && firstParam.indexOf("#") != -1) {
                    firstParam = firstParam.substring(0, firstParam.indexOf("#")).trim();
                }
                this.checkName(currentClass, macroCall, firstParam);
            }
        }
    }

    protected abstract void checkName(RfClass var1, MacroCallItem var2, String var3);
}

