/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

public abstract class AbstractUtilsMacroCheck
extends AbstractNamePatternParametersCheck {
    public AbstractUtilsMacroCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected boolean checkUtilsMacroInClass(RfClass classs, boolean checkSharpInFirstMacroArgument, Set<String> expectedMacros, boolean allowOtherMacros, boolean allowTypedefs, boolean allowNonParamMacroForParamClasses) {
        boolean anyHit = false;
        MacroCallInfo macroInfo = classs.getMacroCallInfo();
        HashSet<String> validTypeDefs = new HashSet();
        if (allowTypedefs) {
            validTypeDefs = LintUtils.getValidTypedefsForMacroRegistration(classs);
        }
        if (macroInfo != null) {
            List<MacroCallItem> allMacrosUsed;
            List<MacroCallItem> items = macroInfo.getItems(expectedMacros);
            if (items != null && !items.isEmpty()) {
                Iterator<MacroCallItem> it = items.iterator();
                while (it.hasNext()) {
                    MacroCallItem item = it.next();
                    if (this.fOVMProject.isOVMFile(item.getParserPath().path)) {
                        it.remove();
                        continue;
                    }
                    if (!this.fOVMProject.isReparseStackInOVMFile(item.getReparseInfo())) continue;
                    it.remove();
                }
            }
            Set abstractUtilsMacros = expectedMacros.stream().filter(x -> x.contains("abstract")).collect(Collectors.toSet());
            Set nonAbstractUtilsMacros = expectedMacros.stream().filter(x -> !x.contains("abstract")).collect(Collectors.toSet());
            if (items != null && !items.isEmpty()) {
                anyHit = true;
                MacroCallItem macroCallItem = items.get(0);
                if (classs.hasVirtualQualifier() && !macroCallItem.getName().contains("abstract")) {
                    this.addHit(classs, "Class " + classs.getName() + " is virtual, so " + DVTStringUtil.join(nonAbstractUtilsMacros, (String)",") + " is not allowed");
                    return anyHit;
                }
                if (!classs.hasVirtualQualifier() && macroCallItem.getName().contains("abstract")) {
                    this.addHit(macroCallItem.getParserPath(), macroCallItem.getLineNumber(), "Macro " + macroCallItem.getName() + " was used instead of " + DVTStringUtil.join(nonAbstractUtilsMacros, (String)","), macroCallItem.getReparseInfo());
                    return anyHit;
                }
                String info = null;
                info = !macroCallItem.getName().contains("param") && allowNonParamMacroForParamClasses ? this.fOVMProject.isFirstMacroArgumentTheClass(macroCallItem, classs, false, validTypeDefs) : this.fOVMProject.isFirstMacroArgumentTheClass(macroCallItem, classs, checkSharpInFirstMacroArgument, validTypeDefs);
                if (info != null) {
                    this.addHit(macroCallItem.getParserPath(), macroCallItem.getLineNumber(), "Incorrect first argument of macro '" + macroCallItem.getName() + "'! " + info, macroCallItem.getReparseInfo());
                }
            } else if (!allowOtherMacros && (allMacrosUsed = macroInfo.getItems()) != null) {
                for (MacroCallItem item : allMacrosUsed) {
                    if (!item.getName().contains("_utils")) continue;
                    if (classs.hasVirtualQualifier() && !item.getName().contains("abstract")) {
                        this.addHit(classs, "Class " + classs.getName() + " is virtual, so " + item.getName() + " is not allowed");
                        anyHit = true;
                        continue;
                    }
                    if (!classs.hasVirtualQualifier() && item.getName().contains("abstract")) {
                        this.addHit(item.getParserPath(), item.getLineNumber(), "Macro " + item.getName() + " was used instead of " + DVTStringUtil.join(nonAbstractUtilsMacros, (String)","), item.getReparseInfo());
                        anyHit = true;
                        continue;
                    }
                    this.addHit(item.getParserPath(), item.getLineNumber(), "Macro " + item.getName() + " was used instead of " + DVTStringUtil.join(classs.hasVirtualQualifier() ? abstractUtilsMacros : nonAbstractUtilsMacros, (String)","), item.getReparseInfo());
                    anyHit = true;
                }
            }
        }
        return anyHit;
    }

    protected void checkMacroUtilsBeginEnd(Map<String, RfClass> classes, String utilsNoParamMacro, String beginNoParamMacro, String endNoParamMacro, String utilsParamMacro, String beginParamMacro, boolean exceptVirtualClasses) {
        this.checkMacroUtilsBeginEnd(classes, new HashSet<String>(Arrays.asList(utilsNoParamMacro)), new HashSet<String>(Arrays.asList(beginNoParamMacro)), endNoParamMacro, new HashSet<String>(Arrays.asList(utilsParamMacro)), new HashSet<String>(Arrays.asList(beginParamMacro)), exceptVirtualClasses);
    }

    protected void checkMacroUtilsBeginEnd(Map<String, RfClass> classes, Set<String> utilsNoParamMacro, Set<String> beginNoParamMacro, String endNoParamMacro, Set<String> utilsParamMacro, Set<String> beginParamMacro, boolean exceptVirtualClasses) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        for (RfClass classs : classes.values()) {
            List<MacroCallItem> endItems;
            if (exceptVirtualClasses && classs.hasVirtualQualifier()) continue;
            this.notifyCheckAlive();
            HashSet<String> utilsMacros = new HashSet<String>();
            utilsMacros.addAll(utilsNoParamMacro);
            HashSet<String> beginMacros = new HashSet<String>();
            beginMacros.addAll(beginNoParamMacro);
            String endMacro = endNoParamMacro;
            boolean checkSharpInFirstMacroArgument = false;
            if (classs.hasPortListParameters() && utilsParamMacro != null) {
                utilsMacros.clear();
                beginMacros.clear();
                utilsMacros.addAll(utilsParamMacro);
                beginMacros.addAll(beginParamMacro);
                checkSharpInFirstMacroArgument = true;
            }
            MacroCallInfo macroInfo = classs.getMacroCallInfo();
            boolean anyHit = false;
            if (!(macroInfo == null || (anyHit = this.checkUtilsMacroInClass(classs, checkSharpInFirstMacroArgument, utilsMacros, true, true, false)) || beginMacros.isEmpty() || endMacro == null || (endItems = macroInfo.getItems(endMacro)) == null || endItems.isEmpty())) {
                anyHit = this.checkUtilsMacroInClass(classs, checkSharpInFirstMacroArgument, beginMacros, false, true, false);
            }
            Set nonAbstractUtilsMacros = utilsMacros.stream().filter(x -> !x.contains("abstract")).collect(Collectors.toSet());
            Set nonAbstractBeginMacros = beginMacros.stream().filter(x -> !x.contains("abstract")).collect(Collectors.toSet());
            if (anyHit || classs.hasVirtualQualifier()) continue;
            if (beginMacros.isEmpty() || endMacro == null) {
                this.addHit(classs, "Macro " + DVTStringUtil.join(nonAbstractUtilsMacros, (String)",") + " was not found");
                continue;
            }
            this.addHit(classs, "Macros " + DVTStringUtil.join(nonAbstractUtilsMacros, (String)",") + " or " + DVTStringUtil.join(nonAbstractBeginMacros, (String)",") + " and " + endMacro + " were not found");
        }
    }
}

