/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.utils.Utils;

public abstract class AbstractXVMMacroCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true `xvm_error macro calls in non xvm_components are allowed.", name="allowCallsFromNonComponents", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowCallsFromNonComponents;
    private Set<String> fMacroCalls;
    private Map<MacroCallFailure, Integer> fMacroCallFailures;

    public AbstractXVMMacroCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fMacroCallFailures = new LinkedHashMap<MacroCallFailure, Integer>();
        this.fMacroCalls = this.getMacroCalls();
        if (this.fMacroCalls == null || this.fMacroCalls.isEmpty()) {
            return;
        }
        for (RfClass component : this.fOVMProject.getAllComponents().values()) {
            List<RfFunction> methods;
            RfFileDef file = component.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            if (component instanceof RfSpecializedClass) {
                component = component.getGenericClass();
            }
            if ((methods = this.getMethods(component)) == null || methods.isEmpty()) continue;
            HashMap<String, Set<RfFunction>> visited = new HashMap<String, Set<RfFunction>>();
            for (RfFunction function : methods) {
                this.checkFunction(function, "", 0, visited);
            }
        }
        for (MacroCallFailure key : this.fMacroCallFailures.keySet()) {
            MacroCallItem macroCallItem = key.getItem();
            this.addHit(macroCallItem.getParserPath(), macroCallItem.getLineNumber(), this.getFailMessage(macroCallItem, key.getFunction(), key.functionCallStack), macroCallItem.getReparseInfo());
        }
    }

    protected void checkFunction(RfFunction function, String functionCallStack, int callIndex, Map<String, Set<RfFunction>> visited) {
        if (function == null || function.isPredefined() || visited.get(function.getFullName()) != null && visited.get(function.getFullName()).contains(function)) {
            return;
        }
        if (this.fOVMProject.isOVMElement(function)) {
            return;
        }
        RfNamedElement functionFromGeneric = function.getElementInGenericScope();
        function = functionFromGeneric instanceof RfFunction ? (RfFunction)functionFromGeneric : function;
        visited.putIfAbsent(function.getFullName(), new HashSet());
        visited.get(function.getFullName()).add(function);
        this.checkMacroCall(function, functionCallStack, callIndex);
        LocalHidVisitor visitor = new LocalHidVisitor();
        function.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        Map<RfFunction, FileLineCall> functionsToBeChecked = visitor.getFunctionsToBeChecked();
        if (functionsToBeChecked != null) {
            for (Map.Entry<RfFunction, FileLineCall> entry : functionsToBeChecked.entrySet()) {
                RfFunction functionCalled = entry.getKey();
                FileLineCall fileLine = entry.getValue();
                String lineFileInfo = "calls " + fileLine.getMethodCall() + "() " + "in " + this.link(String.valueOf(Utils.getInstance().getFileName(fileLine.getFile().path)) + ":" + fileLine.getLine(), fileLine.getFile().path, fileLine.getLine());
                this.checkFunction(functionCalled, String.valueOf(functionCallStack) + "\n" + callIndex + ": " + this.link(function) + "() - " + lineFileInfo, callIndex + 1, visited);
            }
        }
    }

    private void checkMacroCall(RfFunction function, String functionCallStack, int callIndex) {
        RfClass enclosingClass;
        if (function == null) {
            return;
        }
        if (this.pAllowCallsFromNonComponents && (enclosingClass = function.getEnclosingScope(RfClass.class)) != null && !enclosingClass.isSubClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component"), true)) {
            return;
        }
        MacroCallInfo macroCallInfo = function.getMacroCallInfo();
        if (macroCallInfo == null) {
            return;
        }
        List<MacroCallItem> macroCallItems = LintUtils.getMacroCallsInSet(macroCallInfo, this.fMacroCalls);
        if (macroCallItems == null) {
            return;
        }
        for (MacroCallItem macroCallItem : macroCallItems) {
            Integer availableCallIndex;
            if (macroCallItem == null || (availableCallIndex = this.fMacroCallFailures.get(new MacroCallFailure(macroCallItem, function, functionCallStack))) != null && availableCallIndex <= callIndex) continue;
            this.fMacroCallFailures.put(new MacroCallFailure(macroCallItem, function, functionCallStack), callIndex);
        }
    }

    protected abstract String getFailMessage(MacroCallItem var1, RfFunction var2, String var3);

    protected abstract List<RfFunction> getMethods(RfNamedElement var1);

    protected abstract Set<String> getMacroCalls();

    private static final class FileLineCall {
        ParserPath file;
        int line;
        String methodCall;

        public FileLineCall(ParserPath parserPath, int line, String methodCall) {
            this.file = parserPath;
            this.line = line;
            this.methodCall = methodCall;
        }

        public ParserPath getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public String getMethodCall() {
            return this.methodCall;
        }
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private Map<RfFunction, FileLineCall> functionsToBeChecked = new LinkedHashMap<RfFunction, FileLineCall>();

        private LocalHidVisitor() {
        }

        public Map<RfFunction, FileLineCall> getFunctionsToBeChecked() {
            return this.functionsToBeChecked;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHid hid) {
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfFunction) || element.isPredefined()) {
                return true;
            }
            RfFunction calledFunction = (RfFunction)element;
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                this.functionsToBeChecked.put(calledFunction, new FileLineCall(this.parserPath, methodCall.occurrence.getLine(), HidUtils.toNiceString((IHidObject)hid)));
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    protected static class MacroCallFailure {
        MacroCallItem item;
        RfFunction function;
        String functionCallStack;

        public MacroCallFailure(MacroCallItem item, RfFunction function, String functionCallStack) {
            this.item = item;
            this.function = function;
            this.functionCallStack = functionCallStack;
        }

        public MacroCallItem getItem() {
            return this.item;
        }

        public RfFunction getFunction() {
            return this.function;
        }

        public String getFunctionCallStack() {
            return this.functionCallStack;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MacroCallFailure other = (MacroCallFailure)obj;
            if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
                return false;
            }
            return !(this.item == null ? other.item != null : !this.item.equals(other.item));
        }
    }
}

