/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.guidelines.Check_R_1000;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroParameter;

@CheckVersion(value="")
@CheckID(value="VERISSIMO_INTERNAL_IEEE_RULE")
@CheckName(value="VERISSIMO_INTERNAL_IEEE_RULE")
@CheckTitle(value="Generate UVM IEEE API details file")
@CheckDescription(value="This rule generates a file containing the UVM IEEE API for R.1000 rule. It needs to be run on an (correctly) annotated UVM IEEE library.")
public class CheckUVMIEEEAPIGenerator
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Path to the location of the output file where the API will be dumped.", name="outputFilePath", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    private String pOutputFilePath;
    private Set<String> deprecatedMacrosAPI;
    private Set<String> deprecatedTypedefsAPI;
    private Set<String> deprecatedClassesAPI;
    private Set<String> deprecatedMethodsAPI;
    private Set<String> deprecatedFieldsAPI;
    private final String UVM_REG_MAP_ADD_MEM = "uvm_pkg::uvm_reg_map.add_mem";
    private final String UVM_REG_GET_LOCAL_MAP = "uvm_pkg::uvm_reg.get_local_map";

    public CheckUVMIEEEAPIGenerator(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performCheckImpl() {
        block29: {
            RfField[] fields;
            RfFunction[] methods;
            RfClass[] classes;
            Object macroQualifiedName232;
            this.deprecatedMacrosAPI = new HashSet<String>();
            this.deprecatedTypedefsAPI = new HashSet<String>();
            this.deprecatedClassesAPI = new HashSet<String>();
            this.deprecatedMethodsAPI = new HashSet<String>();
            this.deprecatedFieldsAPI = new HashSet<String>();
            boolean valid = this.collectDeprecated();
            if (!valid) {
                this.addHit(new ParserPath("none"), 0, "Error during deprecated API collecting.", null);
                return;
            }
            StringBuilder output = new StringBuilder();
            for (VlogMacroInfo macro : this.fOVMProject.getAllMacros()) {
                int length = 0;
                List<VlogMacroParameter> macroParams = null;
                if (macro.getMacroText() != null) {
                    macroParams = macro.getMacroText().getMacroParameters();
                }
                if (macroParams != null && !macroParams.isEmpty()) {
                    length = macroParams.size();
                }
                macroQualifiedName232 = macro.getQualifiedName((IRfScopeElement)null, (ElementPath)null, Check_R_1000.QUALIFIED_NAME_OPTIONS);
                output.append("0 ");
                output.append(String.valueOf(macroQualifiedName232) + " ");
                output.append(this.isDeprecated(0, (String)macroQualifiedName232) ? "1 " : "0 ");
                output.append(this.isContribution(macro.getComment()) ? "1 " : "0 ");
                output.append(this.isImplementation(macro.getComment()) ? "1 " : "0 ");
                output.append("0 ");
                output.append(this.isNonStandard(macro.getComment()) ? "1 " : "0 ");
                output.append(String.valueOf(length) + " ");
                output.append("\n");
                if (macroParams == null) continue;
                int paramNumber = 0;
                for (VlogMacroParameter param : macroParams) {
                    output.append("0, ");
                    output.append(String.valueOf(macroQualifiedName232) + ", ");
                    output.append(String.valueOf(paramNumber) + ", ");
                    output.append(String.valueOf(param.getName()) + ", ");
                    output.append("null, ");
                    output.append(param.getValue() != null ? "1, " : "0, ");
                    output.append("\n");
                    ++paramNumber;
                }
            }
            for (RfNamedElement typeDef : this.fOVMProject.getAllTypedefs()) {
                if (typeDef instanceof RfForwardTypedef || typeDef.getName().equals("type_id")) continue;
                String typedefQualifiedName = typeDef.getQualifiedName((IRfScopeElement)null, (ElementPath)null, Check_R_1000.QUALIFIED_NAME_OPTIONS);
                output.append("1 ");
                output.append(String.valueOf(typedefQualifiedName) + " ");
                output.append(this.isDeprecated(1, typedefQualifiedName) ? "1 " : "0 ");
                output.append(this.isContribution(typeDef.getComment()) ? "1 " : "0 ");
                output.append(this.isImplementation(typeDef.getComment()) ? "1 " : "0 ");
                output.append("0 ");
                output.append(this.isNonStandard(typeDef.getComment()) ? "1 " : "0 ");
                output.append("0 ");
                output.append("\n");
            }
            macroQualifiedName232 = classes = this.fOVMProject.getRfProject().getAllClasses();
            int macroParams = classes.length;
            int typedefQualifiedName = 0;
            while (typedefQualifiedName < macroParams) {
                RfClass cls = macroQualifiedName232[typedefQualifiedName];
                int length = 0;
                List<RfField> params = cls.getParametersWithPrefix("", 384, 2, 1);
                ArrayList<RfField> filterdParams = new ArrayList<RfField>();
                for (RfField param : params) {
                    if (!param.isInParameterPortList()) continue;
                    filterdParams.add(param);
                }
                if (!filterdParams.isEmpty()) {
                    length = filterdParams.size();
                }
                String classQualifiedName = cls.getQualifiedName((IRfScopeElement)null, (ElementPath)null, Check_R_1000.QUALIFIED_NAME_OPTIONS);
                output.append("2 ");
                output.append(String.valueOf(classQualifiedName) + " ");
                output.append(this.isDeprecated(2, classQualifiedName) ? "1 " : "0 ");
                output.append(this.isContribution(cls.getComment()) ? "1 " : "0 ");
                output.append(this.isImplementation(cls.getComment()) ? "1 " : "0 ");
                output.append("0 ");
                output.append(this.isNonStandard(cls.getComment()) ? "1 " : "0 ");
                output.append(String.valueOf(length) + " ");
                output.append("\n");
                if (params != null) {
                    int paramNumber = 0;
                    for (RfField paramField : params) {
                        void var15_36;
                        if (paramField == null || paramField.getDataType() == null) continue;
                        String string = paramField.getDataType().toString();
                        if (paramField.isTypeParameter()) {
                            String string2 = "type";
                        }
                        output.append("2, ");
                        output.append(String.valueOf(classQualifiedName) + ", ");
                        output.append(String.valueOf(paramNumber) + ", ");
                        output.append(String.valueOf(paramField.getName()) + ", ");
                        output.append(String.valueOf(var15_36) + ", ");
                        output.append(paramField.getInitialValue(false) != null ? "1, " : "0, ");
                        output.append("\n");
                        ++paramNumber;
                    }
                }
                ++typedefQualifiedName;
            }
            RfFunction[] rfFunctionArray = methods = this.fOVMProject.getRfProject().getAllFunctionsAndTasks();
            int macroQualifiedName232 = methods.length;
            macroParams = 0;
            while (macroParams < macroQualifiedName232) {
                RfFunction method = rfFunctionArray[macroParams];
                if (!method.isPredefined() && !method.isPrivate()) {
                    boolean isNonStandard = this.isNonStandard(method.getComment());
                    if (method.isVirtual() && isNonStandard) {
                        isNonStandard = this.analyzeVirtualMethod(method);
                    }
                    if (method.isConstructor()) {
                        isNonStandard = false;
                    }
                    List<IRfFieldElement> arguments = method.getArguments();
                    int length = 0;
                    if (arguments != null && !arguments.isEmpty()) {
                        length = arguments.size();
                    }
                    String isDeviation = "0 ";
                    String methodName = method.getQualifiedName((IRfScopeElement)null, (ElementPath)null, Check_R_1000.QUALIFIED_NAME_OPTIONS);
                    if (methodName.equals("uvm_pkg::uvm_reg.get_local_map") || methodName.equals("uvm_pkg::uvm_reg_map.add_mem")) {
                        isDeviation = "1 ";
                    }
                    output.append("3 ");
                    output.append(String.valueOf(methodName) + " ");
                    output.append(this.isDeprecated(3, methodName) ? "1 " : "0 ");
                    output.append(this.isContribution(method.getComment()) ? "1 " : "0 ");
                    output.append(this.isImplementation(method.getComment()) ? "1 " : "0 ");
                    output.append(isDeviation);
                    output.append(isNonStandard ? "1 " : "0 ");
                    output.append(String.valueOf(length) + " ");
                    output.append("\n");
                    if (arguments != null) {
                        int argumentNumber = 0;
                        for (IRfNamedElement iRfNamedElement : arguments) {
                            if (!(iRfNamedElement instanceof RfField)) continue;
                            RfField argumentField = (RfField)iRfNamedElement;
                            String type = this.getType(argumentField);
                            output.append("3, ");
                            output.append(String.valueOf(methodName) + ", ");
                            output.append(String.valueOf(argumentNumber) + ", ");
                            output.append(String.valueOf(argumentField.getName()) + ", ");
                            output.append(String.valueOf(type) + ", ");
                            output.append(argumentField.getInitialValue(false) != null ? "1, " : "0, ");
                            output.append("\n");
                            ++argumentNumber;
                        }
                    }
                }
                ++macroParams;
            }
            RfField[] rfFieldArray = fields = this.fOVMProject.getRfProject().getAllFields();
            int n = fields.length;
            macroQualifiedName232 = 0;
            while (macroQualifiedName232 < n) {
                RfField field = rfFieldArray[macroQualifiedName232];
                if (!field.isPredefined() && !field.isPrivate()) {
                    String fieldName = field.getQualifiedName((IRfScopeElement)null, (ElementPath)null, Check_R_1000.QUALIFIED_NAME_OPTIONS);
                    if (field.getEnclosingScope() instanceof RfStruct) {
                        fieldName = field.getFullNameLabel();
                    }
                    output.append("4 ");
                    output.append(String.valueOf(fieldName) + " ");
                    output.append(this.isDeprecated(4, fieldName) ? "1 " : "0 ");
                    output.append(this.isContribution(field.getComment()) ? "1 " : "0 ");
                    output.append(this.isImplementation(field.getComment()) ? "1 " : "0 ");
                    output.append("0 ");
                    output.append(this.isNonStandard(field.getComment()) ? "1 " : "0 ");
                    output.append("0 ");
                    output.append("\n");
                }
                ++macroQualifiedName232;
            }
            BufferedWriter bw = null;
            try {
                try {
                    File file = new File(LintUtils.replaceAllSystemVariables(this.fOVMProject.getProject(), this.pOutputFilePath, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL));
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    bw = new BufferedWriter(new FileWriter(file));
                    bw.write(output.toString());
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTUtilsCommon.INSTANCE.closeClosable(bw);
                    break block29;
                }
            }
            catch (Throwable throwable) {
                DVTUtilsCommon.INSTANCE.closeClosable(bw);
                throw throwable;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)bw);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean analyzeVirtualMethod(RfFunction function) {
        isNonStandard = true;
        functionClass = function.getEnclosingScope(RfClass.class);
        if (functionClass != null) ** GOTO lbl10
        return isNonStandard;
lbl-1000:
        // 1 sources

        {
            functionClass = functionClass.getParent();
            localFunction = null;
            localFunction = function.isFunction() != false ? functionClass.getFunctionWithPrefix(function.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE) : functionClass.getTaskWithPrefix(function.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (localFunction == null) continue;
            isNonStandard = this.isNonStandard(localFunction.getComment());
lbl10:
            // 3 sources

            ** while (isNonStandard && functionClass.getParent() != null)
        }
lbl11:
        // 1 sources

        return isNonStandard;
    }

    private boolean collectDeprecated() {
        boolean returnedValue;
        block20: {
            returnedValue = true;
            URL file = OVMUtils.class.getResource("/ro/amiq/vlogdt/linter/ruleset/only_deprecated_api_1800.2-2020-1.1.properties");
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(file.openStream(), StandardCharsets.UTF_8));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String[] splits = DVTStringUtil.split((String)" ", (String)line);
                        if (splits == null || splits.length != 2) continue;
                        int type = Integer.parseInt(splits[0]);
                        String fullName = splits[1];
                        switch (type) {
                            case 0: {
                                this.deprecatedMacrosAPI.add(fullName);
                                break;
                            }
                            case 1: {
                                this.deprecatedTypedefsAPI.add(fullName);
                                break;
                            }
                            case 2: {
                                this.deprecatedClassesAPI.add(fullName);
                                break;
                            }
                            case 3: {
                                this.deprecatedMethodsAPI.add(fullName);
                                break;
                            }
                            case 4: {
                                this.deprecatedFieldsAPI.add(fullName);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    returnedValue = false;
                    if (reader == null) break block20;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                        returnedValue = false;
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        returnedValue = false;
                    }
                }
            }
        }
        return returnedValue;
    }

    private String getType(RfField field) {
        IRfNamedElement associatedType;
        IRfNamedElement prevType = associatedType = field.getAssociatedTypeNoLastLevelParams();
        while (associatedType instanceof RfTypeAlias || associatedType instanceof RfStruct) {
            if (associatedType instanceof RfTypeAlias) {
                prevType = associatedType;
                associatedType = ((RfTypeAlias)associatedType).getAssociatedTypeNoLastLevelParams();
            }
            if (!(associatedType instanceof RfStruct)) continue;
            IRfNamedElement structType = ((RfStruct)associatedType).getEnumBaseType();
            if (structType == null) {
                associatedType = prevType;
                break;
            }
            associatedType = structType;
        }
        String type = associatedType.toString();
        if (associatedType instanceof RfField && ((RfField)associatedType).isTypeParameter()) {
            type = "type";
        }
        return type;
    }

    private boolean isDeprecated(int type, String fullName) {
        if (fullName == null) {
            return false;
        }
        switch (type) {
            case 0: {
                return this.deprecatedMacrosAPI.contains(fullName);
            }
            case 1: {
                return this.deprecatedTypedefsAPI.contains(fullName);
            }
            case 2: {
                return this.deprecatedClassesAPI.contains(fullName);
            }
            case 3: {
                return this.deprecatedMethodsAPI.contains(fullName);
            }
            case 4: {
                return this.deprecatedFieldsAPI.contains(fullName);
            }
        }
        return false;
    }

    private boolean isNonStandard(String comment) {
        if (comment == null) {
            return true;
        }
        String standardComment = "@uvm-ieee";
        return !this.analyzeComment(comment, standardComment);
    }

    private boolean isContribution(String comment) {
        if (comment == null) {
            return false;
        }
        String contributionComment = "@uvm-contrib";
        return this.analyzeComment(comment, contributionComment);
    }

    private boolean isImplementation(String comment) {
        if (comment == null) {
            return false;
        }
        String implementationComment = "@uvm-accellera";
        return this.analyzeComment(comment, implementationComment);
    }

    private boolean analyzeComment(String comment, String commentKeyWord) {
        return comment.contains(commentKeyWord);
    }
}

