/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_30_1_0;

@CheckVersion(value="3.2")
@CheckID(value="XVM.10.2")
@CheckName(value="XVM.10.2")
@CheckLabel(labels={RuleLabel.DEPRECATED_API, RuleLabel.METHOD, RuleLabel.UVM_IEEE, RuleLabel.CONFIG_DB, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use 'set_config_int, set_config_string, set_config_object'")
@CheckDescription(value="The following functions are no longer available in the UVM IEEE 1800.2-2020 standard or the implementation library:\n - uvm_pkg::set_config_int()\n - uvm_pkg::set_config_string()\n - uvm_pkg::set_config_object()\n - uvm_pkg::uvm_component.set_config_int()\n - uvm_pkg::uvm_component.set_config_string()\n - uvm_pkg::uvm_component.set_config_object()\n Use instead:\n - uvm_config_db#(int)::set(this, \"*\", \"int_field_name\", value);\n - uvm_config_db#(string)::set(this, \"*\", \"str_field_name\", value);\n - uvm_config_db#(uvm_object)::set(this, \"*\", \"obj_field_name\", obj);\n Note that adding uvm_objects to the configuration database in this fashion will not clone those objects, but will instead push a reference.\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="deprecatedComments", defaultValue="", isVisible=false), @CheckParameterOverride(name="deprecatedMethods", defaultValue="uvm_pkg::set_config_int, uvm_pkg::set_config_string, uvm_pkg::set_config_object, uvm_pkg::uvm_component.set_config_int, uvm_pkg::uvm_component.set_config_string, uvm_pkg::uvm_component.set_config_object", isVisible=false), @CheckParameterOverride(name="allowedPaths", isVisible=false), @CheckParameterOverride(name="invertedFilter", isVisible=false)})
public class Check_10_2
extends Check_SVTB_30_1_0 {
    public Check_10_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String makeMessage(String calledFunctionFullName) {
        return "Removed method call '" + calledFunctionFullName + "()'!";
    }
}

