/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.11")
@CheckID(value="XVM.10.3")
@CheckName(value="XVM.10.3")
@CheckLabel(labels={RuleLabel.DEPRECATED_API, RuleLabel.UVM_IEEE, RuleLabel.MESSAGING, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use UVM IEEE 1800.2-2020 removed global variables for default printers")
@CheckDescription(value="The following global variables for default printers are no longer available in the UVM IEEE 1800.2-2020 standard or the implementation library:\n - uvm_default_printer\n - uvm_default_table_printer\n - uvm_default_line_printer\n - uvm_default_tree_printer\n Use instead accessor methods (and corresponding get methods):\n - uvm_printer::get_default()\n - uvm_table_printer::get_default()\n - uvm_line_printer::get_default()\n - uvm_tree_printer::get_default()\n\nCheck supports pre-waiving.")
public class Check_10_3
extends OVMComplianceCheck {
    private static final String UVM_TREE_PRINTER_GET_DEFAULT = "uvm_tree_printer::get_default()";
    private static final String UVM_LINE_PRINTER_GET_DEFAULT = "uvm_line_printer::get_default()";
    private static final String UVM_TABLE_PRINTER_GET_DEFAULT = "uvm_table_printer::get_default()";
    private static final String UVM_PRINTER_GET_DEFAULT = "uvm_printer::get_default()";
    private static final String UVM_PKG_UVM_DEFAULT_TREE_PRINTER = "uvm_pkg::uvm_default_tree_printer";
    private static final String UVM_PKG_UVM_DEFAULT_LINE_PRINTER = "uvm_pkg::uvm_default_line_printer";
    private static final String UVM_PKG_UVM_DEFAULT_TABLE_PRINTER = "uvm_pkg::uvm_default_table_printer";
    private static final String UVM_PKG_UVM_DEFAULT_PRINTER = "uvm_pkg::uvm_default_printer";
    private static final Map<String, String> DEFAULT_PRINTERS = new HashMap<String, String>();

    public Check_10_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        DEFAULT_PRINTERS.put(UVM_PKG_UVM_DEFAULT_PRINTER, UVM_PRINTER_GET_DEFAULT);
        DEFAULT_PRINTERS.put(UVM_PKG_UVM_DEFAULT_TABLE_PRINTER, UVM_TABLE_PRINTER_GET_DEFAULT);
        DEFAULT_PRINTERS.put(UVM_PKG_UVM_DEFAULT_LINE_PRINTER, UVM_LINE_PRINTER_GET_DEFAULT);
        DEFAULT_PRINTERS.put(UVM_PKG_UVM_DEFAULT_TREE_PRINTER, UVM_TREE_PRINTER_GET_DEFAULT);
        try {
            rfProject.visitHidObject(null, new RfHidVisitor(){

                public boolean visit(RfHid hidObject) {
                    if (hidObject == null) {
                        return true;
                    }
                    IRfNamedElement element = hidObject.getElement();
                    if (!(element instanceof RfField)) {
                        return true;
                    }
                    RfField field = (RfField)element;
                    if (Check_10_3.this.checkPreWaivers(this.parserPath)) {
                        return true;
                    }
                    Check_10_3.this.notifyCheckAlive();
                    String fullName = field.getFullName();
                    if (Check_10_3.this.isDefaultPrinter(fullName)) {
                        Check_10_3.this.addHit(this.parserPath, hidObject, "The global variable '" + fullName + "' is removed, use instead '" + DEFAULT_PRINTERS.get(fullName) + "'!");
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fOVMProject.notifyCheckException(this, e);
        }
    }

    private boolean isDefaultPrinter(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        for (String printer : DEFAULT_PRINTERS.keySet()) {
            if (!fieldName.equals(printer)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

