/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.1")
@CheckName(value="XVM.2.1.1")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.COMPONENT, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="All components must extend xvm_component")
@CheckDescription(value="All components must extend directly or indirectly from xvm_component.\nThe components are: tests, envs, agents, monitors, drivers, sequencers, scoreboards.\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="testClassNamePattern", isVisible=true), @CheckParameterOverride(name="envClassNamePattern", isVisible=true), @CheckParameterOverride(name="agentClassNamePattern", isVisible=true), @CheckParameterOverride(name="monitorClassNamePattern", isVisible=true), @CheckParameterOverride(name="driverClassNamePattern", isVisible=true), @CheckParameterOverride(name="sequencerClassNamePattern", isVisible=true), @CheckParameterOverride(name="scoreboardClassNamePattern", isVisible=true)})
public class Check_2_1_1
extends AbstractNamePatternParametersCheck {
    @CheckParameter(defaultValue="xvm_pkg::xvm_component", description="Check if all components inherit from 'baseClass'.", name="baseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pBaseClassValue;

    public Check_2_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String libComponentName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component");
        RfClass baseClass = null;
        if (!this.pBaseClassValue.isEmpty()) {
            baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClassValue, true);
            if (baseClass == null) {
                this.signalParamError("Class '" + this.pBaseClassValue + "' not found!", false);
                return;
            }
            libComponentName = baseClass.getName();
        }
        this.performComponentsCheck(this.getClassesWithPatterns("testClassNamePattern"), libComponentName, baseClass);
        this.performComponentsCheck(this.getClassesWithPatterns("envClassNamePattern"), libComponentName, baseClass);
        this.performComponentsCheck(this.getClassesWithPatterns("agentClassNamePattern"), libComponentName, baseClass);
        this.performComponentsCheck(this.getClassesWithPatterns("monitorClassNamePattern"), libComponentName, baseClass);
        this.performComponentsCheck(this.getClassesWithPatterns("driverClassNamePattern"), libComponentName, baseClass);
        this.performComponentsCheck(this.getClassesWithPatterns("sequencerClassNamePattern"), libComponentName, baseClass);
        this.performComponentsCheck(this.getClassesWithPatterns("scoreboardClassNamePattern"), libComponentName, baseClass);
    }

    private void performComponentsCheck(Map<String, RfClass> components, String libComponentName, RfClass baseClass) {
        for (RfClass clazz : components.values()) {
            if (!this.pBaseClassValue.isEmpty() && clazz.equals(baseClass)) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(clazz.getFile()) || clazz.isSubClass(libComponentName, true)) continue;
            this.addHit(clazz, "'" + clazz.getName() + "' does not extend '" + libComponentName + "'!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

