/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.10")
@CheckName(value="XVM.2.1.10")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.ANALYSIS_PORT, RuleLabel.COMPONENT, RuleLabel.VERIFICATION, RuleLabel.CLASS_INSTANTIATION})
@CheckTitle(value="Instantiate FIFOs only in the component that uses the FIFO")
@CheckDescription(value="The tlm_fifo and analysis_fifo must be instantiated in the component that uses the FIFO.\nComponents are connected at the parent layer through ports / exports. The parent layer shall not have FIFOs instantiated between components.\n\n Implementation Notes:\nThis check verifies that the FIFOs are instantiated in the components where they are declared.\n\nCheck supports pre-waiving.")
public class Check_2_1_10
extends OVMComplianceCheck {
    public Check_2_1_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfFunctionCall create : this.fOVMProject.getAllCreateCalls()) {
            this.checkInstantiation(create);
        }
        for (RfFunctionCall newCall : this.fOVMProject.getAllNewCalls()) {
            if (newCall.isDynamicArrayNew()) continue;
            this.checkInstantiation(newCall);
        }
    }

    private void checkInstantiation(RfFunctionCall create) {
        this.notifyCheckAlive();
        if (this.checkPreWaivers(create.getFile())) {
            return;
        }
        RfNamedElement createdElem = create.getLeftValue();
        if (createdElem == null || !(createdElem instanceof RfField)) {
            return;
        }
        RfClass createdType = LintUtils.getFieldFinalClassTypeOrNull((RfField)createdElem);
        if (createdType == null) {
            return;
        }
        if (this.fOVMProject.isLibraryFifo(createdType)) {
            RfNamedElement createContainer = create.getClosestTypeContainer();
            RfNamedElement elemContainer = createdElem.getClosestTypeContainer();
            if (createContainer != null && createContainer.equals(elemContainer)) {
                this.addPassedHit(create, "FIFO '" + createdElem.getName() + "' is instantiated where it is declared");
            } else {
                this.addHit(create, "FIFO '" + createdElem.getName() + "' is not instantiated where it is declared");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

