/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractCreateVsNewCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.15")
@CheckName(value="XVM.2.1.15")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Components shall not be constructed directly")
@CheckDescription(value="Components must be created using the factory and not directly constructed with new. This allows a component to be replaced using the factory override methods.\nExample:\nNot Allowed:\nx_driver m_driver_h = new();\nAllowed:\nx_driver_h = x_driver::type_id::create(\"m_driver_h\", this);\n\nCheck supports pre-waiving.")
public class Check_2_1_15
extends AbstractCreateVsNewCheck {
    @CheckParameter(defaultValue="false", description="Skip checking uvm_object based classes creation that are not registered with the factory.", name="skipNonFactoryRegisteredClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipNonFactoryRegisteredClassesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes to skip checking, for example uvm_pkg::uvm_.", name="skipClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipClassesWithPrefixesValue;

    public Check_2_1_15(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_CLASS_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_CLASS_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> allComponentsMap = this.fOVMProject.getAllComponents();
        if (allComponentsMap == null || allComponentsMap.isEmpty()) {
            return;
        }
        this.checkCreateVersusNew();
    }

    @Override
    protected boolean checkType(RfClass createdType) {
        this.notifyCheckAlive();
        Map<String, RfClass> allComponentsMap = this.fOVMProject.getAllComponents();
        if (this.skipClass(createdType)) {
            return false;
        }
        if (this.pSkipNonFactoryRegisteredClassesValue) {
            return allComponentsMap.containsKey(createdType.getFullName()) && this.isFactoryRegistered(createdType);
        }
        return allComponentsMap.containsKey(createdType.getFullName());
    }

    private boolean skipClass(RfClass aClass) {
        return LintUtils.startsWithPrefixes(aClass.getFullName(), this.pSkipClassesWithPrefixesValue);
    }
}

