/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_2_1_15_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractCreatedInstanceNameCheck;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.15.1")
@CheckName(value="XVM.2.1.15.1")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.FIELD, RuleLabel.COMPONENT, RuleLabel.NAME, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="For all fields of a type extending from xvm_component, the constructed string name must match the field name")
@CheckDescription(value="The constructed string name (with either factory create or new) must exactly match the name of the class member that is being created, because XVM builds the hierarchy tree for instance overrides based on the provided string names.\n\nImplementation Notes:\nFor all new and create calls, if the created field is a XVM component, perform the check.\nThe check is performed only if the field class type has a constructor with the first argument 'name'.\n\nExamples:\nmy_component = new (\"my_component\", this);\nm_myifc_driver_h = m_myifc_driver::type_id::create(\"m_myifc_driver_h\", this);\nm_driver_h[ndx] = my_driver::type_id::create($psprintf(\"m_driver_h[%0d]\",ndx), this);\nm_driver_h[e_ndx] = my_driver::type_id::create($psprintf(\"m_driver_h[%s]\",e_ndx.name()),this);\nNot allowed:\nmyifc_driver_h = myifc_driver::type_id::create(\"m_myifc_driver\", this);\nm_driver_h[ndx] = my_driver::type_id::create($psprintf(\"m_driver_h(%0d)\",ndx), this);\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_XVM_2_1_15_1.class)
public class Check_2_1_15_1
extends AbstractCreatedInstanceNameCheck {
    public Check_2_1_15_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkCreatedInstanceName(this.fOVMProject.getAllComponents(), "component");
    }
}

