/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.16")
@CheckName(value="XVM.2.1.16")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Randomization not allowed in components")
@CheckDescription(value="Calling randomize() is not allowed from a component.\nThis restriction allows full control of item / sequence constraints from a test.\nA randomize call within a component cannot easily be constrained from a sequence or testcase.\n\nException: Tests may use randomize().")
public class Check_2_1_16
extends OVMComplianceCheck {
    private static final String RANDOMIZE_STRING = "randomize";

    public Check_2_1_16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> allComponentsMap = this.getComponents();
        for (RfClass component : allComponentsMap.values()) {
            this.notifyCheckAlive();
            ArrayList<RfFunction> functionsAndTasks = new ArrayList<RfFunction>();
            List<RfFunction> localFunctionsAndTasks = component.getLocalMembers(RfFunction.class);
            if (localFunctionsAndTasks != null) {
                functionsAndTasks.addAll(localFunctionsAndTasks);
            }
            ComponentHidVisitor visitor = new ComponentHidVisitor(LintUtils.getNamedElementFullName(component));
            for (RfFunction function : functionsAndTasks) {
                function.visitHidObject(null, visitor);
            }
        }
    }

    private Map<String, RfClass> getComponents() {
        Map<String, RfClass> allComponentsMap = this.fOVMProject.getAllComponents();
        HashMap<String, RfClass> result = new HashMap<String, RfClass>();
        String testClass = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_test");
        for (Map.Entry<String, RfClass> entry : allComponentsMap.entrySet()) {
            RfClass componentClass = entry.getValue();
            if (componentClass == null || componentClass.isSubClass(testClass, true)) continue;
            result.put(entry.getKey(), componentClass);
        }
        return result;
    }

    class ComponentHidVisitor
    extends RfHidVisitor {
        private String componentFullName;

        public ComponentHidVisitor(String componentName) {
            this.componentFullName = componentName;
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfPredefinedFunction) || !Check_2_1_16.RANDOMIZE_STRING.equals(element.getName())) {
                return true;
            }
            HidOccurrence occurrence = hid.getOccurrence();
            if (occurrence == null) {
                return true;
            }
            Check_2_1_16.this.addHit(this.parserPath, occurrence.getLine(), "'" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "()' is used in '" + this.componentFullName + "'!", null);
            return true;
        }
    }
}

