/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.HidHit;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.4")
@CheckID(value="XVM.2.1.17")
@CheckName(value="XVM.2.1.17")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MODULE, RuleLabel.CLASS, RuleLabel.ENVIRONMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not access directly modules from classes")
@CheckDescription(value="Verification environment classes should use only virtual interfaces to access testbench and RTL.\n\nExamples:\n    int value = top.module1_u.inout_port; // NOT ALLOWED\n    uvm_config_db#(logic)::set(this, \"instance_name\", \"field_name\", top.module1_u.inout_port); // NOT ALLOWED\n    uvm_config_db#(virtual interface1)::set(this, \"instance_name\", \"field_name\", top.module1_u.interface1_u); // allowed if allowInterfaceConfig is true\n    uvm_config_db#(virtual interface1.mp)::set(this, \"instance_name\", \"field_name\", top.module1_u.interface1_u.mp); // allowed if allowInterfaceConfig is true\n\nCheck supports pre-waiving.")
public class Check_2_1_17
extends OVMComplianceCheck {
    private static final String MODULE_ACCESS_ERROR_FORMAT = "Illegal module access ''{0}'' in class ''{1}''!";
    private static final String NON_INTERFACE_ACCESS_ERROR_FORMAT = "Illegal module access ''{0}'' in class ''{1}'', only accesses to interface instances or modports are allowed in {2}_config_db#(type T)::set() function!";
    private static final String UVM_CONFIG_DB = "uvm_config_db";
    @CheckParameter(defaultValue="false", description="Allows module access to an interface instance or modport to be passed as argument to xvm_config_db#(type T)::set() function.", name="allowInterfaceConfig", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowInterfaceConfigValue;
    @CheckParameter(defaultValue="false", description="Skips checking for module accesses from classes that are defined inside modules.", name="skipClassesInModules", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipClassesInModules;
    private Map<HidHit, RfHid> configDBHids;
    private Map<HidHit, RfHid> moduleAccessHits;

    public Check_2_1_17(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.configDBHids = new HashMap<HidHit, RfHid>();
        this.moduleAccessHits = new HashMap<HidHit, RfHid>();
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        LocalHidVisitor hidVisitor = new LocalHidVisitor();
        IRfNamedElementVisitor neVisitor = namedElement -> {
            this.notifyCheckAlive();
            if (namedElement instanceof RfClass var4_5) {
                if (classElement.isPredefined() || this.fOVMProject.isOVMElement((RfNamedElement)classElement)) {
                    return true;
                }
                if (this.pSkipClassesInModules && classElement.getEnclosingScope(RfModule.class) != null) {
                    return true;
                }
                hidVisitor.setClass((RfClass)classElement);
                classElement.visitHidObject(rfProject, hidVisitor);
            }
            return true;
        };
        rfProject.accept(neVisitor);
        if (this.pAllowInterfaceConfigValue) {
            this.moduleAccessHits.keySet().removeIf(x -> this.configDBHids.containsKey(x));
            for (Map.Entry<HidHit, RfHid> entry : this.configDBHids.entrySet()) {
                IRfNamedElement element;
                if (entry.getValue() == null || (element = entry.getValue().getElement()) != null && element instanceof RfInstance && (((RfInstance)element).getAssociatedType() instanceof RfInterface || ((RfInstance)element).getAssociatedType() instanceof RfModport) || element instanceof RfInterface || element instanceof RfModport) continue;
                this.addHit(entry.getKey().getParserPath(), entry.getValue(), MessageFormat.format(NON_INTERFACE_ACCESS_ERROR_FORMAT, entry.getValue().getHierarchicalPath(), entry.getKey().getRfClass().getFullName(), this.fOVMProject.getLibraryKindPrefixes()[0]));
            }
        }
        for (Map.Entry<HidHit, RfHid> entry : this.moduleAccessHits.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getKey().getRfClass() == null || entry.getValue().getOccurrence() == null) continue;
            this.addHit(entry.getKey().getParserPath(), entry.getValue().getLine(), MessageFormat.format(MODULE_ACCESS_ERROR_FORMAT, HidUtils.toString((IHidObject)((IHidObject)entry.getValue()), (boolean)true, (boolean)true), entry.getKey().getRfClass().getFullName()), (ReparseInfo)entry.getValue().getOccurrence().getReparseInfo(ReparseInfo.class), true);
        }
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.configDBHids != null) {
            this.configDBHids.clear();
        }
        if (this.moduleAccessHits != null) {
            this.moduleAccessHits.clear();
        }
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        private RfClass fClass;

        LocalHidVisitor() {
        }

        public void setClass(RfClass aClass) {
            this.fClass = aClass;
        }

        public boolean visit(RfHid hid) {
            Check_2_1_17.this.notifyCheckAlive();
            if (hid == null) {
                return true;
            }
            if (Check_2_1_17.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            if (Check_2_1_17.this.pAllowInterfaceConfigValue) {
                this.collectConfigDBHid(hid);
            }
            this.collectModuleAccesses(hid);
            return true;
        }

        private void collectModuleAccesses(RfHid hid) {
            HidOccurrence parentOccurence;
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess == null) {
                return;
            }
            if (parentAccess.getAccessKind() != 0) {
                return;
            }
            Hid parentHid = hid.getAncestorHid();
            if (parentHid == null) {
                return;
            }
            IRfNamedElement parentHidNamedElement = parentHid.getElement();
            if (parentHidNamedElement instanceof RfModule && (parentOccurence = parentHid.getOccurrence()) != null) {
                Check_2_1_17.this.moduleAccessHits.put(new HidHit(this.parserPath, parentHid, parentOccurence, this.fClass), hid);
            }
        }

        private void collectConfigDBHid(RfHid hid) {
            if (hid == null) {
                return;
            }
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return;
            }
            if (!hid.isMethodCall(false)) {
                return;
            }
            if (element.getName() == null || !element.getName().equals("set")) {
                return;
            }
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess == null || parentAccess.getAccessKind() != 2) {
                return;
            }
            if (parentAccess.getParentHid() == null) {
                return;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (parentHid.getElement() == null || !(parentHid.getElement() instanceof RfClass)) {
                return;
            }
            IRfNamedElement parentElement = parentHid.getElement();
            if (parentElement.getName() == null || !parentElement.getName().equals(Check_2_1_17.UVM_CONFIG_DB)) {
                return;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null) {
                return;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall == null || methodCall.argumentValuesMapRaw == null) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    HidOccurrence parentOccurence;
                    IRfNamedElement parentHidNamedElement;
                    Hid parentHidFound;
                    RfHid hidFound;
                    HidAccess parentAccessFound;
                    IHidObject hidArgument = (IHidObject)entry.getValue();
                    if (hidArgument == null || !(hidArgument instanceof RfHid) || (parentAccessFound = (hidFound = (RfHid)hidArgument).getParentAccess()) == null || parentAccessFound.getAccessKind() != 0 || (parentHidFound = hidFound.getAncestorHid()) == null || !((parentHidNamedElement = parentHidFound.getElement()) instanceof RfModule) || (parentOccurence = parentHidFound.getOccurrence()) == null) continue;
                    Check_2_1_17.this.configDBHids.put(new HidHit(this.parserPath, parentHidFound, parentOccurence, this.fClass), hidFound);
                }
            }
        }
    }
}

