/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.5")
@CheckID(value="XVM.2.1.18")
@CheckName(value="XVM.2.1.18")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.SCOREBOARD, RuleLabel.DRIVER, RuleLabel.VERIFICATION})
@CheckTitle(value="Drivers, monitors and scoreboards should not contain handles to drivers, monitors or scoreboards")
@CheckDescription(value="This rule flags fields of type driver, monitor or scoreboard in drivers, monitors and scoreboards.\n\nCheck supports pre-waiving.")
public class Check_2_1_18
extends OVMComplianceCheck {
    RfClass baseScoreboardClass;
    RfClass baseDriverClass;
    RfClass baseMonitorClass;

    public Check_2_1_18(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.baseScoreboardClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_scoreboard"), true);
        if (this.baseScoreboardClass == null) {
            return;
        }
        this.baseDriverClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_driver"), true);
        if (this.baseDriverClass == null) {
            return;
        }
        this.baseMonitorClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_monitor"), true);
        if (this.baseMonitorClass == null) {
            return;
        }
        for (RfNamedElement component : this.fOVMProject.getAllNonXVMClasses()) {
            ParserPath classParserPath;
            RfFileDef file;
            if (!(component instanceof RfClass)) continue;
            boolean scoreboardSubClass = LintUtils.isSubClassOf((RfClass)component, this.baseScoreboardClass);
            boolean driverSubClass = LintUtils.isSubClassOf((RfClass)component, this.baseDriverClass);
            boolean monitorSubClass = LintUtils.isSubClassOf((RfClass)component, this.baseMonitorClass);
            if (!scoreboardSubClass && !driverSubClass && !monitorSubClass || (file = component.getFile()) == null || (classParserPath = file.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            this.notifyCheckAlive();
            if (scoreboardSubClass) {
                this.checkMonitorDriverScorebordInComponent((RfClass)component, "scoreboard");
                continue;
            }
            if (driverSubClass) {
                this.checkMonitorDriverScorebordInComponent((RfClass)component, "driver");
                continue;
            }
            if (!monitorSubClass) continue;
            this.checkMonitorDriverScorebordInComponent((RfClass)component, "monitor");
        }
    }

    private void checkMonitorDriverScorebordInComponent(RfClass component, String parentType) {
        List<RfField> fields = component.getFields();
        if (fields == null) {
            return;
        }
        for (RfField field : fields) {
            RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (fieldType == null) continue;
            if (LintUtils.isSubClassOf(fieldType, this.baseScoreboardClass)) {
                this.addHit(field, "Scoreboard used in " + parentType + " '" + component.getFullName() + "'!");
                continue;
            }
            if (LintUtils.isSubClassOf(fieldType, this.baseDriverClass)) {
                this.addHit(field, "Driver used in " + parentType + " '" + component.getFullName() + "'!");
                continue;
            }
            if (!LintUtils.isSubClassOf(fieldType, this.baseMonitorClass)) continue;
            this.addHit(field, "Monitor used in " + parentType + " '" + component.getFullName() + "'!");
        }
    }
}

