/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractFactoryRegistrationMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.1.1")
@CheckName(value="XVM.2.1.1.1")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION, RuleLabel.REGISTRATION_MACRO, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Factory registration macros for components")
@CheckDescription(value="Component must use factory registration for components (with specific exceptions).\nFor non-parameterized classes this is `xvm_component_utils. For parameterized classes this is `xvm_component_param_utils.\nExample:\n`xvm_component_utils(my_component)\n`xvm_component_param_utils(my_component#(my_params))")
public class Check_2_1_1_1
extends AbstractFactoryRegistrationMacros {
    public Check_2_1_1_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    protected void setLibUtils(boolean isOVMLib) {
        this.libUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_utils") : Arrays.asList("`uvm_component_utils", "`uvm_component_abstract_utils"));
        this.libParamUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_param_utils") : Arrays.asList("`uvm_component_param_utils", "`uvm_component_abstract_param_utils"));
        this.libUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_utils_begin") : Arrays.asList("`uvm_component_utils_begin", "`uvm_component_abstract_utils_begin"));
        this.libUtilsEnd = isOVMLib ? "`ovm_component_utils_end" : "`uvm_component_utils_end";
        this.libParamUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_param_utils_begin") : Arrays.asList("`uvm_component_param_utils_begin", "`uvm_component_abstract_param_utils_begin"));
    }

    @Override
    protected Map<String, RfClass> getElementsMap() {
        HashMap<String, RfClass> allComponentsMap = new HashMap<String, RfClass>();
        allComponentsMap.putAll(this.fOVMProject.getAllComponents());
        return allComponentsMap;
    }
}

