/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractFactoryMacroCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1.2")
@CheckID(value="XVM.2.1.1.1.0")
@CheckName(value="XVM.2.1.1.1.0")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Use the factory registration macros")
@CheckDescription(value="All classes that inherit from 'baseClass' must use the factory registration macros - either 'factoryRegistrationMacro' or 'factoryRegistrationMacroBegin' and 'factoryRegistrationMacroEnd'.\nVirtual classes are skipped, as they shouldn''t be registered to the factory.")
@CheckReapplyDisable
public class Check_2_1_1_1_0
extends AbstractFactoryMacroCheck {
    @CheckParameter(defaultValue="", description="Check only classes that inherit from 'baseClass'.", name="baseClass", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    private String pBaseClassValue;
    @CheckParameter(defaultValue="false", description="Check non parameterized classes, if false. Check parameterized classes, if true.", name="checkParameterizedClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckParameterizedClassesValueTmp;
    @CheckParameter(defaultValue="", description="Comma separated list to filter inheritance subtrees out of the 'baseClass' inheritance tree.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipBaseClassesValue;
    @CheckParameter(defaultValue="", description="If not specified, the existence of this macro is not checked. At least this or 'factoryRegistrationMacroBegin' must be specified.", name="factoryRegistrationMacro", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pFactoryRegistrationMacroValue;
    @CheckParameter(defaultValue="", description="If not specified, the existence of this macro is not checked. At least this or 'factoryRegistrationMacro' must be specified.", name="factoryRegistrationMacroBegin", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pFactoryRegistrationMacroBeginValue;
    @CheckParameter(defaultValue="", description="The existence of this macro is checked only if the 'factoryRegistrationMacroBegin' macro exists. Must be specified if 'factoryRegistrationMacroBegin' is specified.", name="factoryRegistrationMacroEnd", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pFactoryRegistrationMacroEndValue;
    @CheckParameter(defaultValue="", description="Comma separated list to filter inheritance subtrees inside certain packages.", name="skipPackages", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipPackagesValue;
    @CheckParameter(defaultValue="false", description="When true, the rule checks the parameter arguments of the parameterized class used as macro argument.", name="checkParameterizedArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean fCheckParameterizedArgumentsValue;
    @CheckParameter(defaultValue="true", description="When true, the factory registration macros can be called in other macros in the class. For example, to enforce the usage of `xvm_object_utils macro instead of `xvm_sequence_utils for sequences, this parameter should be set to false because the `xvm_sequence_utils macro definition contains the `xvm_object_utils macro call.", name="allowMacrosCalledInOtherMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowMacrosCalledInOtherMacros;

    public Check_2_1_1_1_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        if (this.pFactoryRegistrationMacroValue != null && !this.pFactoryRegistrationMacroValue.isEmpty()) {
            relevantMacros.add(this.pFactoryRegistrationMacroValue);
        }
        if (this.pFactoryRegistrationMacroBeginValue != null && !this.pFactoryRegistrationMacroBeginValue.isEmpty()) {
            relevantMacros.add(this.pFactoryRegistrationMacroBeginValue);
        }
        if (this.pFactoryRegistrationMacroEndValue != null && !this.pFactoryRegistrationMacroEndValue.isEmpty()) {
            relevantMacros.add(this.pFactoryRegistrationMacroEndValue);
        }
        if (!relevantMacros.isEmpty()) {
            aRfProject.lintTrackMacrosByNames("class", relevantMacros);
        }
    }

    @Override
    public void performCheckImpl() {
        if (this.pFactoryRegistrationMacroValue == null && this.pFactoryRegistrationMacroBeginValue == null) {
            this.addHit(null, "At least on of the rule parameters, 'factoryRegistrationMacro' or 'factoryRegistrationMacroBegin', must be specified!");
            return;
        }
        if (this.pFactoryRegistrationMacroBeginValue != null && this.pFactoryRegistrationMacroEndValue == null) {
            this.addHit(null, "Rule parameter 'factoryRegistrationMacroEnd' must be specified, if 'factoryRegistrationMacroBegin' is specified!");
            return;
        }
        if (this.pBaseClassValue == null || this.pBaseClassValue.isEmpty()) {
            this.addHit(null, "Mandatory parameter 'baseClass' must be specified and cannot be empty!");
            return;
        }
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClassValue, true);
        if (baseClass == null) {
            this.addHit(null, "Class specified by parameter 'baseClass': '" + this.pBaseClassValue + "' was not found!");
            return;
        }
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(baseClass);
        this.checkFactoryRegistrationMacro(baseClass.getChildren(), this.pCheckParameterizedClassesValueTmp, this.pFactoryRegistrationMacroValue, this.pFactoryRegistrationMacroBeginValue, this.pFactoryRegistrationMacroEndValue, this.pSkipBaseClassesValue, this.pSkipPackagesValue, visited);
    }

    void checkFactoryRegistrationMacro(Collection<RfClass> aClasses, boolean aCheckParameterizedClasses, String aFactoryRegistrationMacro, String aFactoryRegistrationMacroBegin, String aFactoryRegistrationMacroEnd, HashSet<String> aSkipBaseClasses, HashSet<String> aSkipPackages, Set<RfClass> visited) {
        if (aClasses == null) {
            return;
        }
        for (RfClass eachClass : aClasses) {
            if (visited.contains(eachClass = eachClass.getGenericClass())) continue;
            visited.add(eachClass);
            this.checkFactoryRegistrationMacro(eachClass, aCheckParameterizedClasses, aFactoryRegistrationMacro, aFactoryRegistrationMacroBegin, aFactoryRegistrationMacroEnd, aSkipBaseClasses, aSkipPackages, visited);
        }
    }

    void checkFactoryRegistrationMacro(RfClass aClass, boolean aCheckParameterizedClasses, String aFactoryRegistrationMacro, String aFactoryRegistrationMacroBegin, String aFactoryRegistrationMacroEnd, HashSet<String> aSkipBaseClasses, HashSet<String> aSkipPackages, Set<RfClass> visited) {
        this.notifyCheckAlive();
        if (aClass == null) {
            return;
        }
        if (aSkipBaseClasses != null && aSkipBaseClasses.contains(aClass.getFullName())) {
            return;
        }
        if (aClass.hasVirtualQualifier()) {
            this.checkFactoryRegistrationMacro(aClass.getChildren(), aCheckParameterizedClasses, aFactoryRegistrationMacro, aFactoryRegistrationMacroBegin, aFactoryRegistrationMacroEnd, aSkipBaseClasses, aSkipPackages, visited);
            return;
        }
        if (aClass.getEnclosingScope() != null && aClass.getEnclosingScope() instanceof RfPackage && aSkipPackages.contains(aClass.getEnclosingScope().getName())) {
            this.checkFactoryRegistrationMacro(aClass.getChildren(), aCheckParameterizedClasses, aFactoryRegistrationMacro, aFactoryRegistrationMacroBegin, aFactoryRegistrationMacroEnd, aSkipBaseClasses, aSkipPackages, visited);
            return;
        }
        if (aCheckParameterizedClasses && !aClass.hasPortListParameters() || !aCheckParameterizedClasses && aClass.hasPortListParameters()) {
            this.checkFactoryRegistrationMacro(aClass.getChildren(), aCheckParameterizedClasses, aFactoryRegistrationMacro, aFactoryRegistrationMacroBegin, aFactoryRegistrationMacroEnd, aSkipBaseClasses, aSkipPackages, visited);
            return;
        }
        if (aFactoryRegistrationMacro == null) {
            if (aFactoryRegistrationMacroBegin != null) {
                boolean okFactoryRegistrationMacroEnd;
                boolean okFactoryRegistrationMacroBegin = this.checkFactoryMacroInClass(aClass, aFactoryRegistrationMacroBegin, true, this.fCheckParameterizedArgumentsValue, this.pAllowMacrosCalledInOtherMacros);
                if (!okFactoryRegistrationMacroBegin) {
                    this.addHit(aClass, "Expected macro '" + aFactoryRegistrationMacroBegin + "' not found or incorrect use!");
                } else if (aFactoryRegistrationMacroEnd != null && !(okFactoryRegistrationMacroEnd = this.checkFactoryMacroInClass(aClass, aFactoryRegistrationMacroEnd, false, this.fCheckParameterizedArgumentsValue, this.pAllowMacrosCalledInOtherMacros))) {
                    this.addHit(aClass, "Expected macro '" + aFactoryRegistrationMacroEnd + "' not found!");
                }
            }
        } else {
            boolean okFactoryRegistrationMacro = this.checkFactoryMacroInClass(aClass, aFactoryRegistrationMacro, true, this.fCheckParameterizedArgumentsValue, this.pAllowMacrosCalledInOtherMacros);
            if (!okFactoryRegistrationMacro) {
                if (aFactoryRegistrationMacroBegin == null) {
                    this.addHit(aClass, "Expected macro '" + aFactoryRegistrationMacro + "' not found or incorrect use!");
                } else {
                    boolean okFactoryRegistrationMacroEnd;
                    boolean okFactoryRegistrationMacroBegin = this.checkFactoryMacroInClass(aClass, aFactoryRegistrationMacroBegin, true, this.fCheckParameterizedArgumentsValue, this.pAllowMacrosCalledInOtherMacros);
                    if (!okFactoryRegistrationMacroBegin) {
                        this.addHit(aClass, "Expected macros '" + aFactoryRegistrationMacro + "' or '" + aFactoryRegistrationMacroBegin + "' and '" + aFactoryRegistrationMacroEnd + "' were not found or incorrect use!");
                    } else if (aFactoryRegistrationMacroEnd != null && !(okFactoryRegistrationMacroEnd = this.checkFactoryMacroInClass(aClass, aFactoryRegistrationMacroEnd, false, this.fCheckParameterizedArgumentsValue, this.pAllowMacrosCalledInOtherMacros))) {
                        this.addHit(aClass, "Expected macro '" + aFactoryRegistrationMacroEnd + "' not found!");
                    }
                }
            }
        }
        this.checkFactoryRegistrationMacro(aClass.getChildren(), aCheckParameterizedClasses, aFactoryRegistrationMacro, aFactoryRegistrationMacroBegin, aFactoryRegistrationMacroEnd, aSkipBaseClasses, aSkipPackages, visited);
    }
}

