/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.1.2")
@CheckName(value="XVM.2.1.1.2")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Forbidden abstract components")
@CheckDescription(value="Do not use virtual keyword with component classes. Components declared with the virtual keyword are abstract.\nSuch components cannot use `xvm_component_utils since factory registration uses \"new\" which is illegal for abstract classes.\n\nCheck supports pre-waiving.")
public class Check_2_1_1_2
extends OVMComplianceCheck {
    public Check_2_1_1_2(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass component : this.fOVMProject.getAllComponents().values()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(component.getFile()) || !component.hasVirtualQualifier()) continue;
            this.addHit(component, "Component '" + component.getName() + "' is declared virtual");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

