/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsMacroCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.2.11")
@CheckID(value="XVM.2.1.1.2.0")
@CheckName(value="XVM.2.1.1.2.0")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use factory registration macros for virtual classes")
@CheckDescription(value="Virtual classes are abstract, they cannot be allocated (constructed).\nSuch classes cannot use the `xvm_..._utils macros since factory registration uses \"new\" which is illegal for abstract classes.\n\nCheck supports pre-waiving.")
public class Check_2_1_1_2_0
extends AbstractUtilsMacroCheck {
    @CheckParameter(defaultValue="xvm_component_utils, xvm_component_param_utils, xvm_component_utils_begin, xvm_component_param_utils_begin,xvm_component_utils_end, xvm_object_utils, xvm_object_param_utils, xvm_object_utils_begin, xvm_object_param_utils_begin, xvm_object_utils_end", description="Comma separated list of forbidden factory registration macros.", name="factoryRegistrationMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pFactoryRegistrationMacrosValue;

    public Check_2_1_1_2_0(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("class", this.pFactoryRegistrationMacrosValue);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement eachNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
            List<MacroCallItem> macroCalls;
            RfClass eachClass;
            MacroCallInfo macroInfo;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(eachNamedElement.getFile()) || eachNamedElement == null || !(eachNamedElement instanceof RfClass) || !eachNamedElement.hasVirtualQualifier() || (macroInfo = (eachClass = (RfClass)eachNamedElement).getMacroCallInfo()) == null || (macroCalls = macroInfo.getItems()) == null || macroCalls.isEmpty()) continue;
            for (MacroCallItem macroCall : macroCalls) {
                ReparseInfo reparseInfo;
                String macroCallName;
                if (macroCall == null || !this.pFactoryRegistrationMacrosValue.contains(macroCallName = macroCall.getName()) || (reparseInfo = macroCall.getReparseInfo()) != null && reparseInfo.getReparseStackSize() == 0) continue;
                this.addHit(macroCall.getParserPath(), macroCall.getLineNumber(), "Class " + eachClass.getName() + " is virtual, " + macroCallName + " is not allowed!", macroCall.getReparseInfo());
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

