/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsMacroCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="20.1.25")
@CheckID(value="XVM.2.1.1.2.1")
@CheckName(value="XVM.2.1.1.2.1")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.CLASS, RuleLabel.CONSTRUCTOR, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use factory registration macros for classes with protected or local constructor")
@CheckDescription(value="Protected or local constructors can not be called from outside.\nSuch classes cannot use the `xvm_..._utils macros since factory registration uses \"new\" which is illegal for classes with no public constructor.")
public class Check_2_1_1_2_1
extends AbstractUtilsMacroCheck {
    public static final String[] OVM_FACTORY_CLASS_MACROS = new String[]{"`ovm_sequence_utils", "`ovm_sequence_utils_begin", "`ovm_sequence_utils_end", "`ovm_component_utils", "`ovm_component_param_utils", "`ovm_component_utils_begin", "`ovm_component_param_utils_begin", "`ovm_component_utils_end", "`ovm_object_utils", "`ovm_object_param_utils", "`ovm_object_utils_begin", "`ovm_object_param_utils_begin", "`ovm_object_utils_end", "`ovm_sequencer_utils", "`ovm_sequencer_param_utils", "`ovm_sequencer_utils_begin", "`ovm_sequencer_param_utils_begin", "`ovm_sequencer_utils_end"};
    public static final String[] UVM_FACTORY_CLASS_MACROS = new String[]{"`uvm_sequence_utils", "`uvm_sequence_utils_begin", "`uvm_sequence_utils_end", "`uvm_component_utils", "`uvm_component_param_utils", "`uvm_component_utils_begin", "`uvm_component_param_utils_begin", "`uvm_component_utils_end", "`uvm_object_utils", "`uvm_object_param_utils", "`uvm_object_utils_begin", "`uvm_object_param_utils_begin", "`uvm_object_utils_end", "`uvm_sequencer_utils", "`uvm_sequencer_param_utils", "`uvm_sequencer_utils_begin", "`uvm_sequencer_param_utils_begin", "`uvm_sequencer_utils_end"};
    private static final HashSet<String> UVM_FACTORY_MACRO_CALLS = new HashSet<String>(Arrays.asList(UVM_FACTORY_CLASS_MACROS));
    private static final HashSet<String> OVM_FACTORY_MACRO_CALLS = new HashSet<String>(Arrays.asList(OVM_FACTORY_CLASS_MACROS));
    private HashSet<String> fMacroCalls = new HashSet();

    public Check_2_1_1_2_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        this.fMacroCalls = isOVMLib ? OVM_FACTORY_MACRO_CALLS : UVM_FACTORY_MACRO_CALLS;
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("class", this.fMacroCalls);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement namedElement : this.fOVMProject.getAllNonXVMClasses()) {
            List<MacroCallItem> macroCalls;
            MacroCallInfo macroInfo;
            this.notifyCheckAlive();
            if (!(namedElement instanceof RfClass)) continue;
            RfClass currentClass = (RfClass)namedElement;
            boolean targetedConstructors = false;
            List<RfFunction> constructors = currentClass.getConstructorsWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (!constructors.isEmpty()) {
                for (RfFunction constructor : constructors) {
                    if (!constructor.isProtected() && !constructor.isPrivate()) continue;
                    targetedConstructors = true;
                    break;
                }
            }
            if (!targetedConstructors || (macroInfo = currentClass.getMacroCallInfo()) == null || (macroCalls = macroInfo.getItems()) == null || macroCalls.isEmpty()) continue;
            for (MacroCallItem macroCall : macroCalls) {
                String macroCallName;
                if (macroCall == null || !this.fMacroCalls.contains(macroCallName = macroCall.getName())) continue;
                this.addHit(macroCall.getParserPath(), macroCall.getLineNumber(), "Class " + currentClass.getName() + " has protected or local constructors, " + macroCallName + " is not allowed!", macroCall.getReparseInfo());
            }
        }
    }
}

