/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsBeginEndMacroCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedEventType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="16.1.17")
@CheckID(value="XVM.2.1.1.3")
@CheckName(value="XVM.2.1.1.3")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Field macros must match field type")
@CheckDescription(value="Utility field macros `xvm_field_* must match the type of the fields they handle.\n\nCheck supports pre-waiving.")
public class Check_2_1_1_3
extends AbstractUtilsBeginEndMacroCheck {
    @CheckParameter(defaultValue="false", description="When true, fields with parametrizable types must be registered with the macros corresponding to the default type of the parameter, otherwise `xvm_field_object is expected.", name="useTypeParameterDefaultValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pUseTypeParameterDefaultValue;
    private HashSet<String> relevantMacros = new HashSet();

    public Check_2_1_1_3(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
        this.relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_FIELD_MACROS));
        this.relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_FIELD_MACROS));
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("class", this.relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement elem : this.fOVMProject.getAllNonXVMClasses()) {
            List<MacroCallItem> macroCalls;
            RfClass clazz;
            MacroCallInfo macroInfo;
            this.notifyCheckAlive();
            if (elem == null || !(elem instanceof RfClass) || this.checkPreWaivers(elem) || (macroInfo = (clazz = (RfClass)elem).getMacroCallInfo()) == null || (macroCalls = LintUtils.getMacroCallsInSet(macroInfo, this.relevantMacros, false, false)) == null || macroCalls.isEmpty()) continue;
            for (MacroCallItem macroCall : macroCalls) {
                DataType dataType;
                IRfNamedElement namedElement;
                String macroCallName = macroCall.getName();
                String argumentName = null;
                String argumentTypeFromMacroName = null;
                String associativeArrayKeyFromMacroName = null;
                StringBuilder associativeArrayValueFromMacroName = null;
                String elementFromMacroName = null;
                String fieldKey = null;
                String field_value = null;
                if (!macroCallName.contains("_field_")) continue;
                argumentTypeFromMacroName = macroCallName.split("_field_")[1];
                argumentName = macroCallName.contains("enum") || macroCallName.contains("enumkey") ? macroCall.getMacroParameters()[1] : macroCall.getMacroParameters()[0];
                if (argumentTypeFromMacroName.contains("aa")) {
                    String[] splittedMacroName = argumentTypeFromMacroName.split("_");
                    associativeArrayKeyFromMacroName = splittedMacroName[1];
                    if ("object".equals(associativeArrayKeyFromMacroName)) {
                        associativeArrayKeyFromMacroName = "uvm_" + associativeArrayKeyFromMacroName;
                    }
                    associativeArrayValueFromMacroName = new StringBuilder();
                    int i = 2;
                    while (i < splittedMacroName.length) {
                        associativeArrayValueFromMacroName.append(splittedMacroName[i]);
                        if (i != splittedMacroName.length - 1) {
                            associativeArrayValueFromMacroName.append(' ');
                        }
                        ++i;
                    }
                } else if (argumentTypeFromMacroName.contains("array") || argumentTypeFromMacroName.contains("queue")) {
                    elementFromMacroName = argumentTypeFromMacroName.split("_")[1];
                    if ("object".equals(elementFromMacroName)) {
                        elementFromMacroName = "uvm_" + elementFromMacroName;
                    }
                } else if (argumentTypeFromMacroName.contains("event") || argumentTypeFromMacroName.contains("enum") || argumentTypeFromMacroName.contains("int") || argumentTypeFromMacroName.contains("string") || argumentTypeFromMacroName.contains("real")) {
                    elementFromMacroName = argumentTypeFromMacroName;
                } else if (argumentTypeFromMacroName.contains("object")) {
                    elementFromMacroName = "uvm_" + argumentTypeFromMacroName;
                }
                RfField field = clazz.getFieldWithPrefix(argumentName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (field == null) {
                    field = clazz.getEventWithPrefix(argumentName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                }
                if (field == null || (namedElement = field.getAssociatedType()) == null || (dataType = field.getDataType()) == null) continue;
                IRfNamedElement associatedTypeNoParams = field.getAssociatedTypeNoLastLevelParams();
                if (associatedTypeNoParams instanceof RfListType) {
                    associatedTypeNoParams = ((RfListType)associatedTypeNoParams).getAssociatedTypeNoLastLevelParams();
                }
                IRfNamedElement finalType = null;
                if (!this.pUseTypeParameterDefaultValue && associatedTypeNoParams instanceof RfField && ((RfField)associatedTypeNoParams).isTypeParameter()) {
                    fieldKey = "uvm_object";
                } else {
                    if (associatedTypeNoParams instanceof RfField && ((RfField)associatedTypeNoParams).isTypeParameter()) {
                        finalType = ((RfField)associatedTypeNoParams).getAssociatedTypeNoLastLevelParams();
                        if (finalType instanceof RfListType || finalType instanceof RfTypeAlias) {
                            LintUtils.FullTypeData finalDataType = LintUtils.getAssociatedFinalDataType((RfAssociatedType)finalType);
                            finalType = finalDataType.getAssocType();
                            dataType = finalDataType.getAssocDataType();
                        }
                        fieldKey = finalType.getName();
                    } else {
                        fieldKey = dataType.getType();
                        RfAssociatedTypeWrapper assocTypeWrapper = new RfAssociatedTypeWrapper(dataType, (RfNamedElement)namedElement);
                        finalType = LintUtils.getAssociatedFinalType(assocTypeWrapper);
                        if (finalType != null) {
                            fieldKey = finalType.getName();
                        }
                    }
                    if (!"uvm_object".equals(fieldKey)) {
                        if (finalType instanceof RfClass) {
                            fieldKey = Check_2_1_1_3.getBaseClass((RfClass)finalType);
                        } else if (finalType instanceof RfStruct) {
                            if (((RfStruct)finalType).isEnum()) {
                                fieldKey = "enum";
                            } else if (((RfStruct)finalType).isPacked()) {
                                namedElement = finalType;
                                fieldKey = "int";
                            }
                        } else if (namedElement instanceof RfTypeAlias) {
                            namedElement = finalType;
                        }
                    }
                }
                if (namedElement instanceof RfListType && ((RfListType)namedElement).isAssociativeArray()) {
                    RfListType associativeArray = (RfListType)namedElement;
                    RfAssociatedTypeWrapper wrap = new RfAssociatedTypeWrapper(associativeArray.getIndexTypeRaw(), associativeArray);
                    LintUtils.FullTypeData associatedPair = LintUtils.getAssociatedFinalDataType(wrap);
                    IRfNamedElement associatedTypeNoParamsValue = wrap.getAssociatedTypeNoLastLevelParams();
                    if (associatedTypeNoParamsValue instanceof RfField && ((RfField)associatedTypeNoParamsValue).isTypeParameter()) {
                        if (!this.pUseTypeParameterDefaultValue) {
                            field_value = "uvm_object";
                        } else {
                            finalType = ((RfField)associatedTypeNoParamsValue).getAssociatedTypeNoLastLevelParams();
                            LintUtils.FullTypeData finalDataType = LintUtils.getAssociatedFinalDataType((RfField)associatedTypeNoParamsValue);
                            if (finalDataType.getAssocDataType() != null) {
                                field_value = finalDataType.getAssocDataType().getTypeName(null, null);
                            }
                            if (finalDataType.getAssocType() instanceof RfStruct) {
                                field_value = "enumkey";
                                if (finalDataType.getAssocDataType() == null || finalDataType.getAssocType() == null) {
                                    field_value = finalType.getName();
                                }
                            }
                        }
                    } else {
                        if (associatedPair.getAssocDataType() != null) {
                            field_value = associatedPair.getAssocDataType().getTypeName(null, null);
                        }
                        if (associatedPair.getAssocType() instanceof RfStruct) {
                            field_value = "enumkey";
                        }
                    }
                }
                if (this.checkArgument(argumentTypeFromMacroName, associativeArrayKeyFromMacroName, associativeArrayValueFromMacroName, elementFromMacroName, fieldKey, field_value, namedElement, dataType, finalType)) continue;
                this.addHit(macroCall.getParserPath(), macroCall.getLineNumber(), "Macro '" + macroCall.getName() + "' doesn't match the type of the field '" + field.getFullName() + "'!", null);
            }
        }
    }

    public boolean checkPreWaivers(RfNamedElement elem) {
        if (elem.getFile() == null || elem.getFile().getParserPath() == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(elem.getFile().getParserPath(), this);
    }

    private boolean checkArgument(String argumentTypeFromMacroName, String associativeArrayKeyFromMacroName, StringBuilder associativeArrayValueFromMacroName, String elementFromMacroName, String fieldKey, String field_value, IRfNamedElement namedElement, DataType dataType, IRfNamedElement finalType) {
        return this.checkArgumentAssociativeArray(argumentTypeFromMacroName, associativeArrayKeyFromMacroName, associativeArrayValueFromMacroName, fieldKey, field_value, namedElement) || this.checkArgumentArray(argumentTypeFromMacroName, elementFromMacroName, fieldKey, namedElement) || this.checkArgumentQueue(argumentTypeFromMacroName, elementFromMacroName, fieldKey, namedElement) || this.checkArugmentSArray(argumentTypeFromMacroName, elementFromMacroName, fieldKey, namedElement, dataType) || this.checkArgumentEvent(argumentTypeFromMacroName, elementFromMacroName, fieldKey, namedElement) || this.checkArgumentEnum(argumentTypeFromMacroName, elementFromMacroName, fieldKey, namedElement) || this.checkArgumentInt(argumentTypeFromMacroName, elementFromMacroName, fieldKey, namedElement, dataType, finalType) || this.checkArgumentObject(argumentTypeFromMacroName, elementFromMacroName, fieldKey) || this.checkArgumentString(argumentTypeFromMacroName, elementFromMacroName, fieldKey, namedElement) || this.checkArgumentReal(argumentTypeFromMacroName, elementFromMacroName, fieldKey, namedElement);
    }

    private boolean checkArgumentAssociativeArray(String argumentTypeFromMacroName, String associativeArrayKeyFromMacroName, StringBuilder associativeArrayValueFromMacroName, String fieldKey, String field_value, IRfNamedElement namedElement) {
        return associativeArrayKeyFromMacroName != null && associativeArrayValueFromMacroName != null && argumentTypeFromMacroName.contains("aa") && namedElement instanceof RfListType && ((RfListType)namedElement).isAssociativeArray() && Check_2_1_1_3.checkEqualityWithIntegral(associativeArrayKeyFromMacroName, fieldKey) && associativeArrayValueFromMacroName.toString().equals(field_value);
    }

    private boolean checkArgumentReal(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey, IRfNamedElement namedElement) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("real") && namedElement instanceof RfPredefinedScalarType && LintUtils.REAL_BASE_TYPES.contains(fieldKey);
    }

    private boolean checkArgumentString(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey, IRfNamedElement namedElement) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("string") && namedElement instanceof RfPredefinedScalarType && elementFromMacroName.equals(fieldKey);
    }

    private boolean checkArgumentObject(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("object") && elementFromMacroName.equals(fieldKey);
    }

    private boolean checkArgumentInt(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey, IRfNamedElement namedElement, DataType dataType, IRfNamedElement finalType) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("int") && (namedElement instanceof RfListType && dataType.hasPackedDimension() && !dataType.hasUnpackedDimension() || namedElement instanceof RfStruct && ((RfStruct)namedElement).isPacked() || finalType instanceof RfBitVectorScalarType || fieldKey.contains("enum"));
    }

    private boolean checkArgumentEnum(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey, IRfNamedElement namedElement) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("enum") && namedElement instanceof RfTypeAlias && elementFromMacroName.equals(fieldKey);
    }

    private boolean checkArgumentEvent(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey, IRfNamedElement namedElement) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("event") && namedElement instanceof RfPredefinedEventType && elementFromMacroName.equals(fieldKey);
    }

    private boolean checkArugmentSArray(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey, IRfNamedElement namedElement, DataType dataType) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("sarray") && namedElement instanceof RfListType && !((RfListType)namedElement).isDynamicArray() && Check_2_1_1_3.checkEqualityWithIntegral(elementFromMacroName, fieldKey);
    }

    private boolean checkArgumentQueue(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey, IRfNamedElement namedElement) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("queue") && namedElement instanceof RfListType && ((RfListType)namedElement).isQueue() && Check_2_1_1_3.checkEqualityWithIntegral(elementFromMacroName, fieldKey);
    }

    private boolean checkArgumentArray(String argumentTypeFromMacroName, String elementFromMacroName, String fieldKey, IRfNamedElement namedElement) {
        return elementFromMacroName != null && argumentTypeFromMacroName.contains("array") && namedElement instanceof RfListType && ((RfListType)namedElement).isDynamicArray() && Check_2_1_1_3.checkEqualityWithIntegral(elementFromMacroName, fieldKey);
    }

    private static boolean checkEqualityWithIntegral(String s1, String s2) {
        if ("int".equals(s1) || "[int]".equals(s1)) {
            return LintUtils.INTEGRAL_BASE_TYPES.contains(s2);
        }
        return s1.contains(s2);
    }

    private static String getBaseClass(RfClass clazz) {
        String baseClass = null;
        while (clazz.getParent() != null) {
            if (!"uvm_object".equals((clazz = clazz.getParent()).getName())) continue;
            return clazz.getName();
        }
        baseClass = clazz.getName();
        return baseClass;
    }
}

