/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsFactoryRegistrationMacrosCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="17.1.9")
@CheckID(value="XVM.2.1.1.4")
@CheckName(value="XVM.2.1.1.4")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Classes registered using factory registration macros must be package qualified")
@CheckDescription(value="Classes registered using factory registration macros must be package qualified. This avoids conflicts when classes with the same name but from different packages are registered with the factory and used in factory overrides.\n\nExample:\nNot Allowed: \n `xvm_component_utils(my_component) \nAllowed: \n `xvm_component_utils(my_pkg::my_component)")
public class Check_2_1_1_4
extends AbstractUtilsFactoryRegistrationMacrosCheck {
    public Check_2_1_1_4(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    protected void checkName(RfClass currentClass, MacroCallItem macroCall, String firstParam) {
        if (!firstParam.equals(currentClass.getFullName())) {
            this.addHit(macroCall.getParserPath(), macroCall.getLineNumber(), "Factory registration macro argument '" + firstParam + "' is not matching the enclosing class package qualified name!", macroCall.getReparseInfo());
        }
    }
}

