/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_2_1_1_5;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsFactoryRegistrationMacrosCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="17.1.21")
@CheckID(value="XVM.2.1.1.5")
@CheckName(value="XVM.2.1.1.5")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.CLASS, RuleLabel.NAME, RuleLabel.VERIFICATION})
@CheckTitle(value="Factory registration macros must match the class name")
@CheckDescription(value="Factory registration macros must match the class name.\n\nExample:\nNot Allowed: \n class my_component;\n `xvm_component_utils(my_other_component) \n endclass\nAllowed: \n class my_component;\n `xvm_component_utils(my_component) \n `xvm_component_utils(my_pkg::my_component)\n endclass\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_XVM_2_1_1_5.class)
public class Check_2_1_1_5
extends AbstractUtilsFactoryRegistrationMacrosCheck {
    public Check_2_1_1_5(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    protected void checkName(RfClass currentClass, MacroCallItem macroCall, String firstParam) {
        if (!firstParam.equals(currentClass.getFullName()) && !firstParam.equals(currentClass.getName())) {
            this.addHit(macroCall.getParserPath(), macroCall.getLineNumber(), "Factory registration macro argument '" + firstParam + "' is not matching the enclosing class name!", macroCall.getReparseInfo(), new VerissimoAutofixAdditionalInfo(macroCall, currentClass));
        }
    }
}

