/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractFactoryRegistrationMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="20.1.6")
@CheckID(value="XVM.2.1.1.6")
@CheckName(value="XVM.2.1.1.6")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.OBJECT, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Factory registration macros for objects")
@CheckDescription(value="Objects must use factory registration for objects (with specific exceptions).\nFor non-parameterized classes this is `xvm_object_utils. For parameterized classes this is `xvm_object_param_utils.\nExample:\n`xvm_object_utils(my_object)\n`xvm_object_param_utils(my_object#(my_params))")
@CheckParametersOverrides(value={@CheckParameterOverride(name="allowNonParamUtilsForBaseClasses", isVisible=true, description="Comma separated list of base classes for whose children it is allowed to use `xvm_object_utils instead of `xvm_object_param_utils."), @CheckParameterOverride(name="allowBeginEndMacros", isVisible=true, description="Allows the use of `xvm_object_utils_begin(my_object) or `xvm_object_param_utils_begin(my_object#(my_params)) for items with registered fields.")})
public class Check_2_1_1_6
extends AbstractFactoryRegistrationMacros {
    public Check_2_1_1_6(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    protected void setLibUtils(boolean isOVMLib) {
        this.libUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_utils") : Arrays.asList("`uvm_object_utils", "`uvm_object_abstract_utils"));
        this.libParamUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_param_utils") : Arrays.asList("`uvm_object_param_utils", "`uvm_object_abstract_param_utils"));
        this.libUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_utils_begin") : Arrays.asList("`uvm_object_utils_begin", "`uvm_object_abstract_utils_begin"));
        this.libUtilsEnd = isOVMLib ? "`ovm_object_utils_end" : "`uvm_object_utils_end";
        this.libParamUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_param_utils_begin") : Arrays.asList("`uvm_object_param_utils_begin", "`uvm_object_abstract_param_utils_begin"));
    }

    @Override
    protected Map<String, RfClass> getElementsMap() {
        HashMap<String, RfClass> allObjectsMap = new HashMap<String, RfClass>();
        allObjectsMap.putAll(this.fOVMProject.getAllObjects());
        return allObjectsMap;
    }
}

