/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractConstructorCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.4.1")
@CheckName(value="XVM.2.1.4.1")
@CheckLabel(labels={RuleLabel.CONSTRUCTOR, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Component Constructor")
@CheckDescription(value="The constructor for a component (or component derivative) must look as follows: \n\nfunction new(string name, xvm_component parent);\n  super.new(name, parent);\nendfunction\n\nThe constructor cannot pass additional arguments. \nThe constructor cannot contain additional lines - no constructing child components, no initializing members, no side effects.\n\nImplementation Notes:\n Coverage collector is an exception, the SVTB LRM requires that all coverage groups be constructed in the new method.\n\nCheck supports pre-waiving.")
public class Check_2_1_4_1
extends AbstractConstructorCheck {
    private static final Set<String> EXCLUDED_UVM_CLASSES = new HashSet<String>(Arrays.asList("uvm_root", "uvm_port_component", "uvm_tlm_fifo", "uvm_tlm_req_rsp_channel", "uvm_algorithmic_comparator"));
    private static final Set<String> EXCLUDED_OVM_CLASSES = new HashSet<String>(Arrays.asList("ovm_root", "ovm_port_component", "tlm_fifo", "urm_fifo", "tlm_req_rsp_channel", "ovm_algorithmic_comparator", "avm_algorithmic_comparator"));

    public Check_2_1_4_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap<String, RfClass> classes = new HashMap<String, RfClass>();
        for (RfClass clazz : this.fOVMProject.getAllComponents().values()) {
            RfClass xvmParent = this.getFirstXVMParent(clazz);
            if (xvmParent != null && (this.fOVMProject.getLibraryKind() == 2 && EXCLUDED_UVM_CLASSES.contains(xvmParent.getName()) || this.fOVMProject.getLibraryKind() == 1 && EXCLUDED_OVM_CLASSES.contains(xvmParent.getName()))) continue;
            classes.put(clazz.getFullName(), clazz);
        }
        if (classes.isEmpty()) {
            return;
        }
        this.checkConstructor(classes, true, false);
    }
}

