/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractCreateVsNewCheck;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.4.2.6")
@CheckName(value="XVM.2.1.4.2.6")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="Class fields (variables) should be constructed using \"XVM create calls\"")
@CheckDescription(value="Any variables of a type registered with the factory must be constructed using \"XVM create calls\".\n\n Implementation Notes:\n This rule loops over all \"XVM create\" and \"new\" calls. It fails on \"new\" calls for xvm_objects registered to the factory.\n Unlike XVM52, it doesn't fail if the object is not registered with the factory.\n\nCheck supports pre-waiving.")
public class Check_2_1_4_2_6
extends AbstractCreateVsNewCheck {
    public Check_2_1_4_2_6(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_CLASS_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_CLASS_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> allComponentsMap = this.fOVMProject.getAllComponents();
        if (allComponentsMap == null || allComponentsMap.isEmpty()) {
            return;
        }
        this.checkCreateVersusNew();
    }

    @Override
    protected boolean checkType(RfClass createdType) {
        this.notifyCheckAlive();
        String fOvmUvmObjectName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
        return createdType.isSubClass(fOvmUvmObjectName, true) && this.isFactoryRegistered(createdType);
    }
}

