/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractCreatedInstanceNameCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.4.2.7")
@CheckName(value="XVM.2.1.4.2.7")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.COMPONENT, RuleLabel.NAME, RuleLabel.VERIFICATION})
@CheckTitle(value="For all class fields inside a XVM component, the constructed string name must match the field name")
@CheckDescription(value="The constructed string name (with either factory create or new) must exactly match the name of the class member that is being created, because XVM builds the hierarchy tree for instance overrides based on the provided string names.\n\nImplementation Notes:\nFor all new and create calls, if the created field is inside a XVM component and it is a class type, perform the check.\nThe check is performed only if the field class type has a constructor with the first argument 'name'.\n\nExamples:\nm_analysis_fifo_h = new(\"m_analysis_fifo_h\", this);\nm_agent_h = my_agent::type_id::create(\"m_agent_h\", this);\nm_agent_h[ndx] = my_agent::type_id::create($psprintf(\"m_agent_h[%0d]\",ndx), this);\nm_agent_h[e_ndx] = my_agent::type_id::create($psprintf(\"m_agent_h[%s]\",e_ndx.name()),this);\nNot Allowed:\nm_analysis_fifo_h = new(\"analysis_fifo\", this);\nagent_h[ndx] = new($psprintf(\"agent_h(%0d)\",ndx), this);\n\nCheck supports pre-waiving.")
public class Check_2_1_4_2_7
extends AbstractCreatedInstanceNameCheck {
    public Check_2_1_4_2_7(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> allComponentsMap = this.fOVMProject.getAllComponents();
        if (allComponentsMap == null || allComponentsMap.isEmpty()) {
            return;
        }
        this.checkCreatedInstanceNameInParentClasses(null, allComponentsMap, null, "component's member variable", false, null, false);
    }
}

