/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.4.2.8")
@CheckName(value="XVM.2.1.4.2.8")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.ARGUMENT, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Create call arguments")
@CheckDescription(value="Use 'this' as the second argument of a create call in order to provide a proper context for factory instance overrides.\nException: Must use sequencer as the second argument when creating a non-virtual sequence in a test. The sequencer base class is xvm_sequencer.\n\nExamples:\nmonitor = my_monitor::type_id::create(\"monitor\", null); //not allowed\nmonitor = my_monitor::type_id::create(\"monitor\", this); //allowed\n\nuvm_sequencer sequencer;\nsequence = my_sequence::type_id::create(\"sequence\", this); //not allowed\nsequence = my_sequence::type_id::create(\"sequence\", sequencer); //allowed\n\nImplementation Notes:\n Only create calls from components are checked.\n\nCheck supports pre-waiving.")
public class Check_2_1_4_2_8
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="Allow tests to create a sequence without checking the context.", name="allowSequenceCreateWithoutContext", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowSequenceCreateWithoutContextValue;
    @CheckParameter(defaultValue="false", description="Skip checking create calls that generate singleton objects.", name="skipSingletonObjects", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pSkipSingletonObjects;
    @CheckParameter(defaultValue="uvm_pkg::uvm_sequence_item", description="Comma separated list of class full names. Sequences that extend uvm_sequence with one of these classes as type parameter will be considered virtual sequences.", name="typeParametersForVirtualSequences", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    Set<String> pTypeParametersForVirtualSequences;
    @CheckParameter(defaultValue="", description="Comma separated list of class full names. Sequences that extend one of these classes will be considered non-virtual sequences.", name="nonVirtualSequencesBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    Set<String> pNonVirtualSequencesBaseClasses;

    public Check_2_1_4_2_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final Map<String, RfClass> allComponentsMap = this.fOVMProject.getAllComponents();
        if (allComponentsMap == null || allComponentsMap.isEmpty()) {
            return;
        }
        final String objectRegistryClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_registry");
        final String componentRegistryClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component_registry");
        final String packageName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg");
        final Set sequenceItemClasses = this.pTypeParametersForVirtualSequences.stream().map(sequenceItemClassName -> this.fOVMProject.getRfProject().getClass((String)sequenceItemClassName, true)).collect(Collectors.toSet());
        final Set nonVirtualSequencesBaseClasses = this.pNonVirtualSequencesBaseClasses.stream().map(sequenceItemClassName -> this.fOVMProject.getRfProject().getClass((String)sequenceItemClassName, true)).collect(Collectors.toSet());
        final HashMap hidsSingletonMap = new HashMap();
        HidOperatorVisitor hidOperatorVisitor = new HidOperatorVisitor(new HidOperatorQualifier[0]){

            public boolean visit(HidOperator operator) {
                if (!(operator instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator hidOperator = (RfHidOperator)operator;
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                Set rhHids = hidOperator.getRHHids(HidFlatteningOption.NONE_EXCLUDED);
                IHidObject lhValue = hidOperator.getLHValue();
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                RfHid lhHid = (RfHid)lhValue;
                if (lhHid.getElement() == null || !lhHid.getElement().isStorageStatic()) {
                    return true;
                }
                if (rhHids == null || rhHids.isEmpty()) {
                    return true;
                }
                for (IHid rhHid : rhHids) {
                    boolean isSingleton;
                    RfHid hid;
                    boolean isCreateCall;
                    if (!(rhHid instanceof RfHid) || !(isCreateCall = Check_2_1_4_2_8.this.checkIsCreate(hid = (RfHid)rhHid, packageName, componentRegistryClassName, objectRegistryClassName)) || !(isSingleton = LintUtils.isSingletonCall(lhHid, hid, this.scope, false, false))) continue;
                    hidsSingletonMap.putIfAbsent(this.parserPath, new HashSet());
                    Set hidOccurrenceSet = (Set)hidsSingletonMap.get(this.parserPath);
                    hidOccurrenceSet.add(hid.getOccurrence());
                    hidsSingletonMap.put(this.parserPath, hidOccurrenceSet);
                }
                return true;
            }
        };
        RfHidVisitor visitor = new RfHidVisitor(){
            private IRfNamedElement scope;

            @Override
            public void setHolder(IHidHolder holder) {
                this.scope = ((RfHidHolder)holder).getScope();
            }

            public boolean visit(RfHid hid) {
                Set hidOccurrenceSet;
                if (hidsSingletonMap.containsKey(this.parserPath) && (hidOccurrenceSet = (Set)hidsSingletonMap.get(this.parserPath)).contains(hid.getOccurrence())) {
                    return true;
                }
                boolean isCreateCall = Check_2_1_4_2_8.this.checkIsCreate(hid, packageName, componentRegistryClassName, objectRegistryClassName);
                if (!isCreateCall) {
                    return true;
                }
                IRfNamedElement createdClass = hid.getParentHid().getParentHid().getElement();
                if (createdClass == null || !(createdClass instanceof RfNamedElement)) {
                    return false;
                }
                if (createdClass instanceof RfAssociatedType) {
                    createdClass = LintUtils.getAssociatedFinalType((RfAssociatedType)createdClass, RfTypesResolver.create((IRfScopeElement)this.scope, this.scope.getRfProject(), 6));
                }
                if (!(createdClass instanceof RfClass)) {
                    Check_2_1_4_2_8.this.addHit(this.parserPath, hid, "Created type '" + LintUtils.getNamedElementFullName((RfNamedElement)createdClass) + "' is not a class");
                    return false;
                }
                RfClass enclosingClass = null;
                enclosingClass = this.scope instanceof RfClass ? (RfClass)this.scope : (RfClass)this.scope.getEnclosingScope(RfClass.class);
                if (enclosingClass == null) {
                    return true;
                }
                if (((Check_2_1_4_2_8)Check_2_1_4_2_8.this).fOVMProject.fTests.containsKey(enclosingClass.getFullName()) && Check_2_1_4_2_8.this.fOVMProject.isSequenceOrTheSequenceBaseClass((RfClass)createdClass)) {
                    if (Check_2_1_4_2_8.this.isPhysicalSequence((RfClass)createdClass, sequenceItemClasses, nonVirtualSequencesBaseClasses)) {
                        Check_2_1_4_2_8.this.checkCreateArgument(this.parserPath, hid, true, false);
                    } else {
                        Check_2_1_4_2_8.this.checkCreateArgument(this.parserPath, hid, false, true);
                    }
                } else if (allComponentsMap.containsKey(enclosingClass.getFullName()) && ((RfClass)createdClass).isSubClass(OVMUtils.prependLibraryPrefixTo(Check_2_1_4_2_8.this.fOVMProject.getLibraryKind(), "_component"), true)) {
                    Check_2_1_4_2_8.this.checkCreateArgument(this.parserPath, hid, false, false);
                }
                return true;
            }
        };
        for (RfClass component : allComponentsMap.values()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(component.getFile())) continue;
            if (this.pSkipSingletonObjects) {
                component.visitHidObject(null, (IHidVisitor<?>)hidOperatorVisitor);
            }
            component.visitHidObject(null, visitor);
        }
    }

    private boolean checkIsCreate(RfHid hid, String packageName, String componentRegistryClassName, String objectRegistryClassName) {
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfFunction)) {
            return false;
        }
        if (!element.getName().equals("create")) {
            return false;
        }
        IRfScopeElement enclosingScope = element.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass) || !((RfClass)enclosingScope).getFullName().equals(String.valueOf(packageName) + "::" + componentRegistryClassName) && !((RfClass)enclosingScope).getFullName().equals(String.valueOf(packageName) + "::" + objectRegistryClassName)) {
            return false;
        }
        Hid typeIDHid = hid.getParentHid();
        if (!(typeIDHid instanceof RfHid) || !((RfHid)typeIDHid).getName().equals("type_id")) {
            return false;
        }
        Hid parentHid = typeIDHid.getParentHid();
        return parentHid instanceof RfHid;
    }

    protected void checkCreateArgument(ParserPath parserPath, RfHid rfHid, boolean checkSequencer, boolean isVirtualSequence) {
        List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
        if (methodCalls.isEmpty()) {
            return;
        }
        block0: for (MethodCall methodCall : methodCalls) {
            if (methodCall.argumentValuesMap == null) {
                this.addHitForMethodCall(parserPath, checkSequencer, isVirtualSequence, methodCall);
                continue;
            }
            boolean checkedParentArgument = false;
            for (Map.Entry argumentEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                RfNamedElement associatedClassType;
                IRfNamedElement element;
                IRfNamedElement argumentKey = (IRfNamedElement)argumentEntry.getKey();
                if (argumentKey == null || !argumentKey.getName().equals("parent")) continue;
                checkedParentArgument = true;
                IHidObject hidObject = (IHidObject)argumentEntry.getValue();
                if (!(hidObject instanceof RfHid) && !(hidObject instanceof RfHidAccess)) {
                    this.addHitForMethodCall(parserPath, checkSequencer, isVirtualSequence, methodCall);
                    continue block0;
                }
                Hid hid = null;
                if (hidObject instanceof RfHidAccess) {
                    hid = ((RfHidAccess)hidObject).getParentHid();
                } else if (hidObject instanceof RfHid) {
                    hid = (Hid)hidObject;
                } else {
                    this.addHitForMethodCall(parserPath, checkSequencer, isVirtualSequence, methodCall);
                    continue block0;
                }
                if (hid.getElement() != null ? (element = hid.getElement()) instanceof RfAssociatedType && (associatedClassType = LintUtils.getAssociatedFinalType((IRfAssociatedTypeElement)element)) instanceof RfClass && (!checkSequencer ? element instanceof RfThisImplicitVariable : this.fOVMProject.fSequencers != null && this.fOVMProject.isSequencerOrTheSequencerBaseClass((RfClass)associatedClassType)) : (checkSequencer || isVirtualSequence) && this.pAllowSequenceCreateWithoutContextValue && hid.getName().equals("null")) continue block0;
                this.addHitForMethodCall(parserPath, checkSequencer, isVirtualSequence, methodCall);
            }
            if (checkedParentArgument) continue;
            this.addHitForMethodCall(parserPath, checkSequencer, isVirtualSequence, methodCall);
        }
    }

    private void addHitForMethodCall(ParserPath parserPath, boolean checkSequencer, boolean isVirtualSequence, MethodCall methodCall) {
        if ((checkSequencer || isVirtualSequence) && this.pAllowSequenceCreateWithoutContextValue) {
            return;
        }
        if (!checkSequencer) {
            this.addHit(parserPath, methodCall.occurrence, "Create called from a component doesn't use 'this' as a second argument.");
        } else {
            this.addHit(parserPath, methodCall.occurrence, "Create called from a test creating a sequence doesn't use a sequencer as the second argument.");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    public boolean isPhysicalSequence(RfClass clazz, Set<RfClass> virtualSequenceItemClasses, Set<RfClass> nonVirtualSequencesBaseClasses) {
        if (clazz == null || clazz.getParent() == null) {
            return false;
        }
        if (nonVirtualSequencesBaseClasses.contains(clazz)) {
            return true;
        }
        return clazz instanceof RfSpecializedClass && !(clazz.getParent() instanceof RfSpecializedClass) ? this.checkClassParameters((RfSpecializedClass)clazz, virtualSequenceItemClasses) : this.isPhysicalSequence(clazz.getParent(), virtualSequenceItemClasses, nonVirtualSequencesBaseClasses);
    }

    private boolean checkClassParameters(RfSpecializedClass clazz, Set<RfClass> sequenceItemClasses) {
        List<RfField> parameters = clazz.getLocalParameters(256);
        if (parameters == null) {
            return false;
        }
        for (IRfNamedElement iRfNamedElement : parameters) {
            IRfNamedElement finalParamValue;
            IELParamValue typeParameterValue = clazz.getElabConstantValue(iRfNamedElement.getName());
            if (typeParameterValue == null || (finalParamValue = typeParameterValue.getNamedElement()) == null || !(finalParamValue instanceof RfClass) || !sequenceItemClasses.stream().anyMatch(sequenceItemClass -> LintUtils.isSubClassOf((RfClass)finalParamValue, sequenceItemClass)) || sequenceItemClasses.stream().anyMatch(sequenceItemClass -> finalParamValue.equals(sequenceItemClass))) continue;
            return true;
        }
        return false;
    }
}

