/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.4.3")
@CheckName(value="XVM.2.1.4.3")
@CheckLabel(labels={RuleLabel.CONNECT_PHASE, RuleLabel.COMPONENT, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory Connect Phase")
@CheckDescription(value="At the connect phase all the components have been installed and configured. At this point those components can be connected to each other.\nThe connect phase method is where all child components of this component are connected and TLM ports are connected to exports.\nThe connect phase method must be defined in all components, including leaf components, for consistency.\n\nExceptions: tests and sequencers.")
@CheckReapplyDisable
public class Check_2_1_4_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, leaf components will not be checked.", name="skipLeafComponents", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipLeafComponents;
    private static final Set<String> FACTORY_CREATE_FUNCTION_NAMES = new HashSet<String>();
    private static String objectRegistryClassName;
    private static String componentRegistryClassName;
    private static String objectWrapperClassName;
    private static String factoryClassName;
    private static String componentClassName;

    static {
        FACTORY_CREATE_FUNCTION_NAMES.add("create_object_by_type");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_object_by_name");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_component_by_type");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_component_by_name");
    }

    public Check_2_1_4_3(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
        objectRegistryClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_registry");
        componentRegistryClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component_registry");
        objectWrapperClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_wrapper");
        factoryClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_factory");
        componentClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component");
    }

    @Override
    public void performCheckImpl() {
        String xvmConnectPhaseMethodName = this.fOVMProject.getConnectPhaseMethodName();
        for (RfClass component : this.fOVMProject.getAllComponents().values()) {
            if (this.pSkipLeafComponents && this.isLeafComponent(component) || this.fOVMProject.fTests.containsKey(component.getFullName()) || this.fOVMProject.fSequencers.containsKey(component.getFullName())) continue;
            this.notifyCheckAlive();
            List<RfFunction> connectCandidates = component.getFunctionsWithPrefix(xvmConnectPhaseMethodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            connectCandidates.addAll(component.getTasksWithPrefix(xvmConnectPhaseMethodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            if (!connectCandidates.isEmpty()) continue;
            this.addHit(component, "'" + component.getName() + "' does not define a " + xvmConnectPhaseMethodName + "() method!");
        }
    }

    private boolean isLeafComponent(RfClass component) {
        List<RfField> fields = component.getFields();
        if (fields == null) {
            return true;
        }
        HashSet<RfField> classFields = new HashSet<RfField>();
        for (RfField field : fields) {
            RfClass type = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (type == null || !type.isSubClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object"), true)) continue;
            classFields.add(field);
        }
        LocalHidOperatorVisitor visitor = new LocalHidOperatorVisitor(null, classFields, component);
        component.visitHidObject(null, (IHidVisitor<?>)visitor);
        return !visitor.foundCreateCall();
    }

    private boolean isCreateFunction(RfFunction function) {
        String functionName = function.getName();
        RfNamedElement enclosingScope = function.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
            return false;
        }
        RfClass enclosingClass = (RfClass)enclosingScope;
        if (functionName.equals("create") && (enclosingClass.isSubClass(objectRegistryClassName, true) || enclosingClass.isSubClass(componentRegistryClassName, true))) {
            return true;
        }
        if (functionName.equals("create_component") && enclosingClass.isSubClass(componentClassName, true)) {
            return true;
        }
        if (functionName.equals("create_object") && (enclosingClass.isSubClass(objectWrapperClassName, true) || enclosingClass.isSubClass(componentClassName, true))) {
            return true;
        }
        return FACTORY_CREATE_FUNCTION_NAMES.contains(functionName) && enclosingClass.isSubClass(factoryClassName, true);
    }

    private class LocalHidOperatorVisitor
    extends HidOperatorVisitor {
        private Set<RfField> classFields;
        private RfClass enclosingClass;
        private boolean foundCreateCall;

        public LocalHidOperatorVisitor(HidOperatorQualifier[] qualifiers, Set<RfField> classFields, RfClass enclosingClass) {
            super(qualifiers);
            this.classFields = classFields;
            this.enclosingClass = enclosingClass;
        }

        public boolean foundCreateCall() {
            return this.foundCreateCall;
        }

        public boolean visit(HidOperator hidOperator) {
            if (!hidOperator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) && !hidOperator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                return true;
            }
            if (this.scope == null) {
                return true;
            }
            IHidObject lhHidObject = hidOperator.getLHValue();
            if (!(lhHidObject instanceof RfHid || lhHidObject instanceof RfHidAccess || lhHidObject instanceof RfHidImplicit)) {
                return true;
            }
            IRfNamedElement element = null;
            if (lhHidObject instanceof RfHidImplicit) {
                String name = ((RfHidImplicit)lhHidObject).getName();
                element = this.enclosingClass.getLocalMember(RfField.class, name, false);
            } else {
                if (lhHidObject instanceof RfHidAccess) {
                    lhHidObject = ((RfHidAccess)lhHidObject).getParentHid();
                }
                element = ((RfHid)lhHidObject).getElement();
            }
            if (!this.classFields.contains(element)) {
                return true;
            }
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!(rhValue instanceof RfHidAccess)) {
                return true;
            }
            IRfNamedElement rhElement = null;
            if (rhValue instanceof RfHidAccess) {
                Hid parentHid = ((RfHidAccess)rhValue).getParentHid();
                if (!parentHid.isMethodCall(false)) {
                    return true;
                }
                rhElement = parentHid.getElement();
            }
            if (!(rhElement instanceof RfFunction)) {
                return true;
            }
            if (Check_2_1_4_3.this.isCreateFunction((RfFunction)rhElement)) {
                this.foundCreateCall = true;
                return false;
            }
            return true;
        }
    }
}

