/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.flowgraph.EmptyFlowNode;
import ro.amiq.vlogdt.linter.flowgraph.ExecutionFlowGraph;
import ro.amiq.vlogdt.linter.flowgraph.FlowNode;
import ro.amiq.vlogdt.linter.flowgraph.OperatorFlowNode;
import ro.amiq.vlogdt.linter.flowgraph.PredicateState;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.4.4.1")
@CheckName(value="XVM.2.1.4.4.1")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.LOOP, RuleLabel.DRIVER, RuleLabel.MONITOR, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory forever loop in the run phase for drivers and monitors")
@CheckDescription(value="The run phase method must run forever for drivers and monitors.\nThere should be no way to fall out of the run phase thread because the run phase thread is stopped by the XVM mechanisms.\n\nImplementation Notes:\nThis rule applies only to classes that override the run phase method.\n\nExample:\ntask my_comp::run_phase();\n  // setup code\n  fork\n    // additional threads\n  join_none\n  // initialization code\n  forever begin\n  // do component activities and call helper tasks\n  end\nendfunction: run_phase\n\nfork ... forever ... join is also a legal way to run forever.\nA call to my_function() that runs forever is also legal.\n\nCheck supports pre-waiving.")
public class Check_2_1_4_4_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="forever", description="Comma separated list of statements that can be used as infinite loop in the run phase method: forever, for, while, dowhile.", name="allowedInfiniteLoops", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedInfiniteLoops;

    public Check_2_1_4_4_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fMonitors.isEmpty() && this.fOVMProject.fDrivers.isEmpty()) {
            return;
        }
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            this.checkRunMethod(monitor);
        }
        for (RfClass driver : this.fOVMProject.fDrivers.values()) {
            this.checkRunMethod(driver);
        }
    }

    private void checkRunMethod(RfClass component) {
        this.notifyCheckAlive();
        if (this.checkPreWaivers(component.getFile())) {
            return;
        }
        String xvmRunPhaseMethodName = this.fOVMProject.getRunPhaseMethodName();
        RfFunction runPhaseFunction = component.getLocalMember(RfFunction.class, xvmRunPhaseMethodName, false);
        if (runPhaseFunction == null) {
            return;
        }
        Predicate<FlowNode> predicate = node -> this.checkPredicate((FlowNode)node);
        ExecutionFlowGraph executionFlowGraph = this.fOVMProject.getExecutionFlowGraph(runPhaseFunction, this, true);
        executionFlowGraph.setPredicate(predicate);
        boolean value = executionFlowGraph.checkPredicateForEachPossiblePath();
        if (!value) {
            this.addHitOnFunctionDefinition(runPhaseFunction, "'" + runPhaseFunction.getFullName() + "()' doesn't end in a forever loop or any equivalents!");
        }
    }

    private boolean checkPredicate(FlowNode node) {
        if (node instanceof EmptyFlowNode) {
            boolean foreverOk = false;
            boolean doWhileOk = false;
            RfNamedElement nodeBlock = ((EmptyFlowNode)node).getBlock();
            if (!(nodeBlock instanceof RfActionBlock)) {
                return false;
            }
            RfActionBlock nodeActionBlock = (RfActionBlock)nodeBlock;
            if (this.pAllowedInfiniteLoops.contains("forever")) {
                foreverOk = true;
                if (!this.isForeverLoop(nodeActionBlock)) {
                    foreverOk = false;
                }
            }
            if (this.pAllowedInfiniteLoops.contains("dowhile")) {
                doWhileOk = true;
                if (!this.isInfiniteDoWhileLoop(nodeActionBlock)) {
                    doWhileOk = false;
                }
            }
            if (!foreverOk && !doWhileOk) {
                return false;
            }
        } else if (node instanceof OperatorFlowNode) {
            boolean whileOk = false;
            boolean forOk = false;
            if (this.pAllowedInfiniteLoops.contains("while")) {
                whileOk = true;
                if (!this.isInfiniteWhileLoop((OperatorFlowNode)node)) {
                    whileOk = false;
                }
            }
            if (this.pAllowedInfiniteLoops.contains("for")) {
                forOk = true;
                if (!this.isInfiniteForLoop((OperatorFlowNode)node)) {
                    forOk = false;
                }
            }
            if (!whileOk && !forOk) {
                return false;
            }
        } else if (node.getPredicateState() != PredicateState.TRUE) {
            return false;
        }
        IRfScopeElement enclosingScope = node.getEnclosingScope();
        while (!(enclosingScope instanceof RfFunction)) {
            RfActionBlock actionBlock;
            if (enclosingScope == null) {
                return false;
            }
            if (enclosingScope instanceof RfActionBlock && ((actionBlock = (RfActionBlock)enclosingScope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY) || actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE))) {
                return false;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return true;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private boolean isInfiniteDoWhileLoop(RfActionBlock nodeActionBlock) {
        if (!nodeActionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.DO)) {
            return false;
        }
        return this.isNonZeroNumber(nodeActionBlock.getExpression());
    }

    private boolean isForeverLoop(RfActionBlock nodeActionBlock) {
        return nodeActionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FOREVER);
    }

    private boolean isInfiniteForLoop(OperatorFlowNode node) {
        if (node.getEnclosingScope() == null) {
            return false;
        }
        if (node.getEnclosingScope() instanceof RfActionBlock) {
            RfActionBlock nodeActionBlock = (RfActionBlock)node.getEnclosingScope();
            if (!nodeActionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FOR)) {
                return false;
            }
            return nodeActionBlock.getExpression().indexOf(";;") != -1;
        }
        return false;
    }

    private boolean isInfiniteWhileLoop(OperatorFlowNode node) {
        RfHidOperator operator = node.getOperator();
        if (operator == null) {
            return false;
        }
        if (!operator.isWhileCondition()) {
            return false;
        }
        return operator.getLHValue() != null && this.isNonZeroNumber(operator.getLHValue().toString());
    }

    private boolean isNonZeroNumber(String number) {
        Number parsedNumber = DVTStringUtil.parseNumberVLOG((String)number, null, (boolean)false);
        return parsedNumber != null && parsedNumber.intValue() != 0;
    }
}

