/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.6")
@CheckName(value="XVM.2.1.6")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.COMPONENT, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Banned xvm_component methods")
@CheckDescription(value="The xvm_component banned methods should not be overridden or called.\n\nImplementation Notes:\nIterates over all classes derived from xvm_component and checks that no banned method is overridden and that no method calls a banned method.\n\nCheck supports pre-waiving.")
public class Check_2_1_6
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="timeout, extract, kill", description="Comma separated list of banned methods names without parens/arguments.", name="bannedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedMethodsValue;

    public Check_2_1_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass eachComponent : this.fOVMProject.getAllComponents().values()) {
            if (this.checkPreWaivers(eachComponent.getFile())) continue;
            ArrayList<RfFunction> allFunctionsInComponent = new ArrayList<RfFunction>();
            List<RfFunction> localFunctionsAndTasks = eachComponent.getLocalMembers(RfFunction.class);
            if (localFunctionsAndTasks != null) {
                allFunctionsInComponent.addAll(localFunctionsAndTasks);
            }
            boolean componentWithBannedFunctions = false;
            for (RfFunction eachFunction : allFunctionsInComponent) {
                List<RfFunctionCall> allFunctionCallsInEachFunction;
                RfNamedElement eachFunctionEnclosingScope;
                if (eachFunction == null) continue;
                this.notifyCheckAlive();
                if (this.pBannedMethodsValue.contains(eachFunction.getName()) && (eachFunctionEnclosingScope = eachFunction.getEnclosingScope()) instanceof RfClass && ((RfClass)eachFunctionEnclosingScope).isSubClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component"), true)) {
                    this.addHit(eachFunction, "Banned '" + eachFunction.getName() + "()' is overridden in '" + eachComponent.getName() + "!'");
                    componentWithBannedFunctions = true;
                }
                if ((allFunctionCallsInEachFunction = eachFunction.getFunctionCallsWithPrefix("", 2)) == null || allFunctionCallsInEachFunction.isEmpty()) continue;
                ArrayList<RfFunctionCall> bannedFunctionCallsInEachFunction = new ArrayList<RfFunctionCall>();
                for (RfFunctionCall eachFunctionCall : allFunctionCallsInEachFunction) {
                    for (String illegalFunction : this.pBannedMethodsValue) {
                        RfNamedElement eachCalledFunctionEnclosingScope;
                        RfFunction eachCalledFunction;
                        if (!eachFunctionCall.hasParentheses() && eachFunctionCall.getFunction() == null || !eachFunctionCall.getName().matches(String.valueOf(illegalFunction) + "|.+\\." + illegalFunction) || (eachCalledFunction = eachFunctionCall.getFunction()) == null || !((eachCalledFunctionEnclosingScope = eachCalledFunction.getEnclosingScope()) instanceof RfClass) || !((RfClass)eachCalledFunctionEnclosingScope).isSubClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component"), true)) continue;
                        bannedFunctionCallsInEachFunction.add(eachFunctionCall);
                    }
                }
                for (RfFunctionCall eachBannedFunctionCall : bannedFunctionCallsInEachFunction) {
                    this.addHit(eachBannedFunctionCall, "Banned '" + eachBannedFunctionCall.getName() + "()' is used in '" + eachComponent.getName() + "'!");
                    componentWithBannedFunctions = true;
                }
            }
            if (componentWithBannedFunctions) continue;
            this.addPassedHit(eachComponent, "No banned functions are overridden or called in '" + eachComponent.getName() + "' component.");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

