/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.8")
@CheckName(value="XVM.2.1.8")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.COMPONENT, RuleLabel.TLM_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Communication between XVM components must be done through TLM ports")
@CheckDescription(value="Communication between XVM components must be done through TLM ports.\nAccess to other components' members from a component is not allowed. Port handles are excepted.\nAccess to DUT internals from a component is not allowed. Use virtual interfaces instead.")
@CheckReapplyDisable
public class Check_2_1_8
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of patterns to match the full name of methods in which to skip checking.", name="skipMethodPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pSkipMethods;
    @CheckParameter(defaultValue="", description="Comma separated list of xvm_root API that may be accessed.", name="skipRootAPICalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pskipXVMRootAPICalls;
    @CheckParameter(defaultValue="", description="Comma separated list of classes full names where xvm_root API, specified using 'skipRootAPICalls', may be accessed.", name="skipRootAPICallsInClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pClassesOfSkippedRootAPICalls;
    @CheckParameter(defaultValue="", description="Comma separated list of methods full names that may be accessed.", name="allowMethodCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowMethodCalls;

    public Check_2_1_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final HashSet<RfNamedElement> allowedFunctions = new HashSet<RfNamedElement>();
        NullProtectedList<RfNamedElement> allFunction = this.fOVMProject.getAllFunctions();
        for (RfNamedElement function : allFunction) {
            String fullName = function.getFullName();
            if (!this.pAllowMethodCalls.contains(fullName)) continue;
            allowedFunctions.add(function);
        }
        HashSet<RfFunction> functionChildren = new HashSet<RfFunction>();
        for (RfNamedElement function : allowedFunctions) {
            RfClass enclosingClass;
            if (function instanceof RfFunction && !((RfFunction)function).isVirtual() || (enclosingClass = function.getEnclosingScope(RfClass.class)) == null) continue;
            functionChildren.addAll(this.getFunctionChildren(function.getName(), new HashSet<RfClass>(), enclosingClass));
        }
        allowedFunctions.addAll(functionChildren);
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){
            private RfNamedElement scope;
            private Map<ParserPath, Set<HidOccurrence>> allowedHidsOccurence = new HashMap<ParserPath, Set<HidOccurrence>>();

            public boolean visit(IHidObject hidObject) {
                switch (hidObject.getHidKind()) {
                    case HID: {
                        HidOccurrence occurrence;
                        RfHid parentHid;
                        RfNamedElement container;
                        RfFileDef file = this.scope.getFile();
                        if (file == null) {
                            return true;
                        }
                        RfFunction enclosingFunction = this.scope.getEnclosingScope(RfFunction.class);
                        if (enclosingFunction != null) {
                            for (Pattern skipMethodPattern : Check_2_1_8.this.pSkipMethods) {
                                if (!skipMethodPattern.matcher(enclosingFunction.getFullName()).matches()) continue;
                                return true;
                            }
                        }
                        ParserPath parserPath = file.getParserPath();
                        if (this.scope instanceof RfFunction && ((RfFunction)this.scope).getImplementation() != null) {
                            parserPath = ((RfFunction)this.scope).getImplementation().getDefFile().getParserPath();
                        }
                        if (!((container = this.scope.getClosestTypeContainer()) instanceof RfClass)) {
                            return true;
                        }
                        if (!((RfClass)container).isSubClass(((Check_2_1_8)Check_2_1_8.this).fOVMProject.fOvmComponent)) {
                            return true;
                        }
                        IRfNamedElement element = ((RfHid)hidObject).getElement();
                        if (element instanceof RfFunction) {
                            boolean twoOrMoreLevelsOfParents;
                            if (((RfFunction)element).isConstructor()) {
                                return true;
                            }
                            Hid parentAccess = ((RfHid)hidObject).getParentHid();
                            boolean bl = twoOrMoreLevelsOfParents = parentAccess != null && parentAccess.getParentHid() != null;
                            if (!twoOrMoreLevelsOfParents && allowedFunctions.contains(element)) {
                                List methodCalls = MethodCallUtils.getMethodCalls((IHid)((RfHid)hidObject));
                                for (MethodCall methodCall : methodCalls) {
                                    Map argVals = methodCall.argumentValuesMapRaw;
                                    for (IHidObject argument : argVals.values()) {
                                        if (!(argument instanceof RfHid)) continue;
                                        HidOccurrence occurence = ((RfHid)argument).getOccurrence(((RfHid)hidObject).getQualifiers());
                                        Set<HidOccurrence> occurences = this.allowedHidsOccurence.get(parserPath);
                                        if (occurences == null) {
                                            occurences = new HashSet<HidOccurrence>();
                                        }
                                        occurences.add(occurence);
                                        this.allowedHidsOccurence.put(parserPath, occurences);
                                    }
                                }
                                return true;
                            }
                        }
                        Check_2_1_8.this.notifyCheckAlive();
                        boolean tlmConnection = false;
                        if (element instanceof RfFunction && (parentHid = (RfHid)((RfHid)hidObject).getParentHid()) != null && parentHid.getElement() instanceof RfField && this.isTLMPortType(parentHid.getElement())) {
                            tlmConnection = true;
                        }
                        if ((occurrence = ((RfHid)hidObject).getOccurrence(HidQualifierCache.LAST_QUALIFIER)) == null && !tlmConnection) {
                            return true;
                        }
                        Set<HidOccurrence> allowedOccurences = this.allowedHidsOccurence.get(parserPath);
                        if (allowedOccurences != null && allowedOccurences.contains(occurrence)) {
                            return true;
                        }
                        RfHid ancestorHid = (RfHid)((RfHid)hidObject).getAncestorHid();
                        if (ancestorHid.getElement() instanceof RfModule) {
                            Check_2_1_8.this.addHit(parserPath, (RfHid)hidObject, "DUT internals accessed using '" + HidUtils.toString((IHidObject)hidObject, (boolean)true, (boolean)true) + "'!");
                        } else if (ancestorHid.getElement() instanceof RfField) {
                            IRfNamedElement associatedType = ((RfField)ancestorHid.getElement()).getAssociatedType();
                            if (associatedType instanceof RfTypeAlias) {
                                associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
                            }
                            if (associatedType instanceof RfInterface) {
                                return true;
                            }
                        }
                        Hid parentHid2 = ((RfHid)hidObject).getParentHid();
                        int xvmComponentParents = 0;
                        boolean moduleParent = false;
                        while (parentHid2 != null) {
                            if (parentHid2.getElement() instanceof RfThisImplicitVariable || parentHid2.getElement() instanceof RfSuperImplicitVariable) {
                                parentHid2 = parentHid2.getParentHid();
                                continue;
                            }
                            if (parentHid2.getElement() instanceof RfModule) {
                                moduleParent = true;
                            }
                            if (!(parentHid2.getElement() instanceof RfField)) {
                                parentHid2 = parentHid2.getParentHid();
                                continue;
                            }
                            IRfNamedElement elementAssociatedType = ((RfField)parentHid2.getElement()).getAssociatedType();
                            if (elementAssociatedType instanceof RfListType) {
                                if (element instanceof RfPredefinedFunction) {
                                    return true;
                                }
                                elementAssociatedType = ((RfListType)elementAssociatedType).getAssociatedType();
                            }
                            if (elementAssociatedType instanceof RfTypeAlias) {
                                elementAssociatedType = ((RfTypeAlias)elementAssociatedType).getAssociatedType();
                            }
                            if (!(elementAssociatedType instanceof RfClass)) {
                                parentHid2 = parentHid2.getParentHid();
                                continue;
                            }
                            boolean elementIsSubclassOfXVMRoot = ((RfClass)elementAssociatedType).isSubClass(OVMUtils.prependLibraryPrefixTo(Check_2_1_8.this.fOVMProject.getLibraryKind(), "_root"), true);
                            if (elementIsSubclassOfXVMRoot && element instanceof RfFunction) {
                                boolean isSkippedClass;
                                String name = element.getName();
                                String containerName = container.getFullName();
                                boolean bl = isSkippedClass = Check_2_1_8.this.pClassesOfSkippedRootAPICalls.isEmpty() || Check_2_1_8.this.pClassesOfSkippedRootAPICalls.contains(containerName);
                                if (isSkippedClass && name != null && Check_2_1_8.this.pskipXVMRootAPICalls.contains(name)) {
                                    return true;
                                }
                            }
                            if (!((RfClass)elementAssociatedType).isSubClass(((Check_2_1_8)Check_2_1_8.this).fOVMProject.fOvmComponent) || elementAssociatedType.equals(((Check_2_1_8)Check_2_1_8.this).fOVMProject.fOvmComponent)) {
                                parentHid2 = parentHid2.getParentHid();
                                continue;
                            }
                            ++xvmComponentParents;
                            parentHid2 = parentHid2.getParentHid();
                        }
                        if (moduleParent) {
                            Check_2_1_8.this.addHit(parserPath, occurrence, "DUT internals accessed using '" + HidUtils.toString((IHidObject)hidObject, (boolean)true, (boolean)true) + "'!");
                            break;
                        }
                        if (xvmComponentParents == 1 && !tlmConnection && !this.isTLMPortType(element)) {
                            Check_2_1_8.this.addHit(parserPath, occurrence, "Component member accessed using '" + HidUtils.toString((IHidObject)hidObject, (boolean)true, (boolean)true) + "'!");
                            break;
                        }
                        if (xvmComponentParents <= true) break;
                        Check_2_1_8.this.addHit(parserPath, occurrence, "Component member accessed using '" + HidUtils.toString((IHidObject)hidObject, (boolean)true, (boolean)true) + "'!");
                        break;
                    }
                }
                return true;
            }

            private boolean isTLMPortType(IRfNamedElement element) {
                if (!(element instanceof RfField)) {
                    return false;
                }
                RfNamedElement associatedType = LintUtils.getAssociatedFinalType((RfField)element);
                if (!(associatedType instanceof RfClass)) {
                    return false;
                }
                boolean isXVMPortBaseChild = ((RfClass)associatedType).isSubClass(Check_2_1_8.this.fOVMProject.getLibraryKind() == 1 ? "ovm_port_base" : "uvm_port_base", true);
                boolean isTlmFifoBaseChild = ((RfClass)associatedType).isSubClass(Check_2_1_8.this.fOVMProject.getLibraryKind() == 1 ? "tlm_fifo_base" : "uvm_tlm_fifo_base", true);
                return isXVMPortBaseChild || isTlmFifoBaseChild;
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }

    private Set<RfFunction> getFunctionChildren(String functionName, Set<RfClass> visited, RfClass enclosingClass) {
        HashSet<RfFunction> result = new HashSet<RfFunction>();
        if (visited.contains(enclosingClass)) {
            return result;
        }
        visited.add(enclosingClass);
        Set<RfClass> childernClasses = enclosingClass.getChildren();
        if (childernClasses == null) {
            return result;
        }
        for (RfClass classs : childernClasses) {
            RfFunction localFunction = classs.getFunctionWithPrefix(functionName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (localFunction != null) {
                result.add(localFunction);
            }
            result.addAll(this.getFunctionChildren(functionName, visited, classs));
        }
        return result;
    }
}

